package ru.yandex.direct.grid.processing.service.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.service.GridFindAndReplaceBannerHrefService;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefParams;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefPayloadItem;
import ru.yandex.direct.grid.processing.model.common.GdCachedResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.service.banner.container.FindAndReplaceBannerHrefParamsCacheRecordInfo;
import ru.yandex.direct.grid.processing.service.cache.GridCacheService;
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.grid.processing.util.findandreplace.BannerHrefParamsReplaceRule;
import ru.yandex.direct.grid.processing.util.findandreplace.BannerTurbolandingParamsReplaceRule;

import static ru.yandex.direct.grid.processing.service.banner.converter.FindAndReplaceBannerHrefConverter.getHrefParamCacheRecordInfo;
import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;

@Service
@ParametersAreNonnullByDefault
public class FindAndReplaceBannerHrefParamService extends AbstractFindAndReplaceBannerHrefService {
    private final GridValidationService inputValidator;

    @Autowired
    public FindAndReplaceBannerHrefParamService(
            GridCacheService cacheService,
            GridFindAndReplaceBannerHrefService hrefService,
            GridValidationService inputValidator, GridValidationResultConversionService validationResultConverter) {
        super(cacheService, hrefService, validationResultConverter);
        this.inputValidator = inputValidator;
    }

    /**
     * Получить превью для Поиска и замены параметров кликовой ссылки баннера
     */
    public GdCachedResult<GdFindAndReplaceAdsHrefPayloadItem> preview(
            GdFindAndReplaceAdsHrefParams input,
            Long operatorUid, ClientId clientId,
            String rootName) {
        inputValidator.validateFindAndReplaceAdHrefParamsRequest(input, pathFromStrings(rootName));
        ReplaceRule replaceRule = new BannerHrefParamsReplaceRule(input.getReplaceInstruction());
        ReplaceRule turbolandingReplaceRule = new BannerTurbolandingParamsReplaceRule(input.getReplaceInstruction());
        FindAndReplaceBannerHrefParamsCacheRecordInfo cacheRecordInfo = getHrefParamCacheRecordInfo(clientId, input);

        return preview(input, operatorUid, clientId, replaceRule, turbolandingReplaceRule, cacheRecordInfo);
    }

    /**
     * Поиск и замена параметров ключевой ссылки баннера
     */
    public GdResult<GdFindAndReplaceAdsHrefPayloadItem> replace(
            GdFindAndReplaceAdsHrefParams input, Long operatorUid, ClientId clientId,
            String rootName) {
        inputValidator.validateFindAndReplaceAdHrefParamsRequest(input, pathFromStrings(rootName));
        ReplaceRule replaceRule = new BannerHrefParamsReplaceRule(input.getReplaceInstruction());
        ReplaceRule turbolandingReplaceRule = new BannerTurbolandingParamsReplaceRule(input.getReplaceInstruction());

        return replace(input, operatorUid, clientId, replaceRule, turbolandingReplaceRule);
    }

}
