package ru.yandex.direct.grid.processing.service.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.grid.core.entity.banner.model.GdReplaceDisplayHrefBanner;
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsDisplayHref;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefDomain;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefParams;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefPayloadItem;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefText;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceCallouts;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceCalloutsPayloadItem;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceText;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceTextPayloadItem;
import ru.yandex.direct.grid.processing.model.common.GdCachedResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;

/**
 * Сервис поиска и замены текстовых полей на баннере
 */
@SuppressWarnings("unused")
@GridGraphQLService
@ParametersAreNonnullByDefault
public class FindAndReplaceGraphQLService {
    private static final String INPUT_ARG_NAME = "input";

    private final FindAndReplaceBannerHrefParamService findAndReplaceBannerHrefParamService;
    private final FindAndReplaceBannerHrefDomainService findAndReplaceBannerHrefDomainService;
    private final FindAndReplaceHrefTextService findAndReplaceHrefTextService;
    private final FindAndReplaceBannersDisplayHrefService findAndReplaceBannersDisplayHrefService;
    private final FindAndReplaceTextService findAndReplaceTextService;
    private final FindAndReplaceCalloutsService findAndReplaceCalloutsService;

    @Autowired
    public FindAndReplaceGraphQLService(FindAndReplaceBannerHrefParamService findAndReplaceBannerHrefParamService,
                                        FindAndReplaceBannerHrefDomainService findAndReplaceBannerHrefDomainService,
                                        FindAndReplaceHrefTextService findAndReplaceHrefTextService,
                                        FindAndReplaceBannersDisplayHrefService findAndReplaceBannersDisplayHrefService,
                                        FindAndReplaceTextService findAndReplaceTextService,
                                        FindAndReplaceCalloutsService findAndReplaceCalloutsService) {
        this.findAndReplaceBannerHrefParamService = findAndReplaceBannerHrefParamService;
        this.findAndReplaceBannerHrefDomainService = findAndReplaceBannerHrefDomainService;
        this.findAndReplaceHrefTextService = findAndReplaceHrefTextService;
        this.findAndReplaceBannersDisplayHrefService = findAndReplaceBannersDisplayHrefService;
        this.findAndReplaceTextService = findAndReplaceTextService;
        this.findAndReplaceCalloutsService = findAndReplaceCalloutsService;
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @GraphQLQuery(name = "getFindAndReplaceAdsHrefParamsPreview")
    public GdCachedResult<GdFindAndReplaceAdsHrefPayloadItem> getFindAndReplaceAdsHrefParamsPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefParams input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannerHrefParamService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findAndReplaceAdsHrefParams")
    public GdResult<GdFindAndReplaceAdsHrefPayloadItem> findAndReplaceAdsHrefParams(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefParams input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannerHrefParamService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @GraphQLQuery(name = "getFindAndReplaceAdsHrefDomainPreview")
    public GdCachedResult<GdFindAndReplaceAdsHrefPayloadItem> getFindAndReplaceAdsHrefDomainPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefDomain input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannerHrefDomainService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findAndReplaceAdsHrefDomain")
    public GdResult<GdFindAndReplaceAdsHrefPayloadItem> findAndReplaceAdsHrefDomain(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefDomain input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannerHrefDomainService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @GraphQLQuery(name = "getFindAndReplaceHrefTextPreview")
    public GdCachedResult<GdFindAndReplaceAdsHrefPayloadItem> getFindAndReplaceHrefTextPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefText input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceHrefTextService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findAndReplaceHrefText")
    public GdResult<GdFindAndReplaceAdsHrefPayloadItem> findAndReplaceHrefText(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsHrefText input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceHrefTextService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @GraphQLNonNull
    @EnableLoggingOnValidationIssues
    @GraphQLQuery(name = "getFindAndReplaceTextPreview")
    public GdCachedResult<GdFindAndReplaceTextPayloadItem> getFindAndReplaceTextPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceText input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceTextService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @GraphQLNonNull
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = "findAndReplaceText")
    public GdResult<GdFindAndReplaceTextPayloadItem> findAndReplaceText(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceText input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceTextService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @GraphQLQuery(name = "getFindAndReplaceDisplayHrefPreview")
    public GdCachedResult<GdReplaceDisplayHrefBanner> getFindAndReplaceDisplayHrefPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsDisplayHref input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannersDisplayHrefService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findAndReplaceDisplayHref")
    public GdResult<GdReplaceDisplayHrefBanner> findAndReplaceDisplayHref(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceAdsDisplayHref input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceBannersDisplayHrefService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @Deprecated // не используется
    @GraphQLNonNull
    @GraphQLQuery(name = "findAndReplaceCalloutsPreview")
    public GdCachedResult<GdFindAndReplaceCalloutsPayloadItem> findAndReplaceCalloutsPreview(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceCallouts input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceCalloutsService.preview(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findAndReplaceCallouts")
    public GdResult<GdFindAndReplaceCalloutsPayloadItem> findAndReplaceCallouts(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = INPUT_ARG_NAME) GdFindAndReplaceCallouts input) {
        //noinspection ConstantConditions
        var clientId = context.getSubjectUser().getClientId();
        return findAndReplaceCalloutsService.replace(input,
                context.getOperator().getUid(), clientId,
                INPUT_ARG_NAME);
    }
}
