package ru.yandex.direct.grid.processing.service.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.service.GridFindAndReplaceBannerHrefService;
import ru.yandex.direct.grid.model.findandreplace.ReplaceRule;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefPayloadItem;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsHrefText;
import ru.yandex.direct.grid.processing.model.common.GdCachedResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.service.banner.container.FindAndReplaceBannerHrefTextCacheRecordInfo;
import ru.yandex.direct.grid.processing.service.cache.GridCacheService;
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.grid.processing.util.findandreplace.BannerHrefTextReplaceRule;

import static ru.yandex.direct.grid.processing.service.banner.converter.FindAndReplaceBannerHrefConverter.getHrefTextCacheRecordInfo;
import static ru.yandex.direct.validation.result.PathHelper.pathFromStrings;

@Service
@ParametersAreNonnullByDefault
public class FindAndReplaceHrefTextService extends AbstractFindAndReplaceBannerHrefService {
    private final GridValidationService inputValidator;

    public FindAndReplaceHrefTextService(
            GridCacheService cacheService,
            GridFindAndReplaceBannerHrefService hrefService,
            GridValidationService inputValidator, GridValidationResultConversionService validationResultConverter) {
        super(cacheService, hrefService, validationResultConverter);
        this.inputValidator = inputValidator;
    }

    public GdCachedResult<GdFindAndReplaceAdsHrefPayloadItem> preview(GdFindAndReplaceAdsHrefText input,
                                                                      Long operatorUid, ClientId clientId, String rootName) {
        inputValidator.validateFindAndReplaceBannerHrefTextRequest(input, pathFromStrings(rootName));
        ReplaceRule replaceRule = new BannerHrefTextReplaceRule(input.getReplaceInstruction());
        FindAndReplaceBannerHrefTextCacheRecordInfo cacheRecordInfo = getHrefTextCacheRecordInfo(clientId, input);

        return preview(input, operatorUid, clientId, replaceRule, replaceRule, cacheRecordInfo);
    }

    public GdResult<GdFindAndReplaceAdsHrefPayloadItem> replace(GdFindAndReplaceAdsHrefText input,
                                                                Long operatorUid, ClientId clientId, String rootName) {
        inputValidator.validateFindAndReplaceBannerHrefTextRequest(input, pathFromStrings(rootName));
        ReplaceRule replaceRule = new BannerHrefTextReplaceRule(input.getReplaceInstruction());

        return replace(input, operatorUid, clientId, replaceRule, replaceRule);
    }
}
