package ru.yandex.direct.grid.processing.service.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.core.entity.banner.model.GdiBanner;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusBsSynced;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusModerate;
import ru.yandex.direct.grid.model.campaign.GdCampaignPrimaryStatus;
import ru.yandex.direct.grid.model.campaign.GdCampaignPrimaryStatusDesc;
import ru.yandex.direct.grid.model.campaign.GdCampaignStatus;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupTruncated;

/**
 * Сервис, считающий вычисляемые поля для внешнего представления описания баннера
 */
@ParametersAreNonnullByDefault
public class GridBannerAggregationFieldsUtils {

    public static Boolean isBannerAimingAllowed(GdiBanner internal, GdAdGroupTruncated group) {
        GdCampaignStatus gdCampaignStatus = group.getCampaign().getStatus();
        return internal.getStatusBsSynced() == GdiBannerStatusBsSynced.YES
                && internal.getStatusModerate() == GdiBannerStatusModerate.YES
                && internal.getStatusShow() && internal.getStatusActive()
                && (gdCampaignStatus.getPrimaryStatus() == GdCampaignPrimaryStatus.ACTIVE
                || gdCampaignStatus.getPrimaryStatus() == GdCampaignPrimaryStatus.TEMPORARILY_PAUSED
                && gdCampaignStatus.getPrimaryStatusDesc() == GdCampaignPrimaryStatusDesc.IS_PAUSED_BY_TIMETARGETING);
    }

}
