package ru.yandex.direct.grid.processing.service.banner.converter;

import java.util.List;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.model.ModelChanges;

import static java.lang.String.format;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class BannerUpdateConverter {

    private BannerUpdateConverter() {
        // no instantiation
    }

    public static List<ModelChanges<BannerWithSystemFields>> bannersToCoreModelChanges(
            List<BannerWithSystemFields> banners) {
        return mapList(banners, BannerUpdateConverter::bannerToCoreModelChanges);
    }

    private static ModelChanges<BannerWithSystemFields> bannerToCoreModelChanges(BannerWithSystemFields banner) {
        ModelChanges<BannerWithSystemFields> result;

        if (banner instanceof TextBanner) {
            result = toModelChanges((TextBanner) banner);
        } else if (banner instanceof ImageBanner) {
            result = toModelChanges((ImageBanner) banner);
        } else if (banner instanceof CpcVideoBanner) {
            result = toModelChanges((CpcVideoBanner) banner);
        } else if (banner instanceof CpmBanner) {
            result = toModelChanges((CpmBanner) banner);
        } else if (banner instanceof CpmAudioBanner) {
            result = toModelChanges((CpmAudioBanner) banner);
        } else if (banner instanceof CpmOutdoorBanner) {
            result = toModelChanges((CpmOutdoorBanner) banner);
        } else if (banner instanceof CpmIndoorBanner) {
            result = toModelChanges((CpmIndoorBanner) banner);
        } else if (banner instanceof CpmGeoPinBanner) {
            result = toModelChanges((CpmGeoPinBanner) banner);
        } else if (banner instanceof PerformanceBanner) {
            result = toModelChanges((PerformanceBanner) banner);
        } else if (banner instanceof PerformanceBannerMain) {
            result = toModelChanges((PerformanceBannerMain) banner);
        } else if (banner instanceof McBanner) {
            result = toModelChanges((McBanner) banner);
        } else if (banner instanceof ContentPromotionBanner) {
            result = toModelChanges((ContentPromotionBanner) banner);
        } else if (banner instanceof MobileAppBanner) {
            result = toModelChanges((MobileAppBanner) banner);
        } else if (banner instanceof DynamicBanner) {
            result = toModelChanges((DynamicBanner) banner);
        } else {
            throw new UnsupportedOperationException(
                    format("Banners of type %s are not supported.", banner.getClass()));
        }
        return result;
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(TextBanner banner) {
        return new ModelChanges<>(banner.getId(), TextBanner.class)
                .process(banner.getTitle(), TextBanner.TITLE)
                .process(banner.getSitelinksSetId(), TextBanner.SITELINKS_SET_ID)
                .process(banner.getTitleExtension(), TextBanner.TITLE_EXTENSION)
                .process(banner.getBody(), TextBanner.BODY)
                .process(banner.getHref(), TextBanner.HREF)
                .processNotNull(banner.getDomain(), TextBanner.DOMAIN)
                .process(banner.getDisplayHref(), TextBanner.DISPLAY_HREF)
                .process(banner.getImageHash(), TextBanner.IMAGE_HASH)
                .process(banner.getCreativeId(), TextBanner.CREATIVE_ID)
                .process(banner.getShowTitleAndBody(), TextBanner.SHOW_TITLE_AND_BODY)
                .process(banner.getCalloutIds(), TextBanner.CALLOUT_IDS)
                .process(banner.getVcardId(), TextBanner.VCARD_ID)
                .process(banner.getTurboLandingHrefParams(), TextBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), TextBanner.TURBO_LANDING_ID)
                .process(banner.getTurboGalleryHref(), TextBanner.TURBO_GALLERY_HREF)
                .process(banner.getBannerPrice(), TextBanner.BANNER_PRICE)
                .process(banner.getPermalinkId(), TextBanner.PERMALINK_ID)
                .process(banner.getPhoneId(), TextBanner.PHONE_ID)
                .process(banner.getPreferVCardOverPermalink(), TextBanner.PREFER_V_CARD_OVER_PERMALINK)
                .process(banner.getLogoImageHash(), TextBanner.LOGO_IMAGE_HASH)
                .process(banner.getButtonAction(), TextBanner.BUTTON_ACTION)
                .process(banner.getButtonCaption(), TextBanner.BUTTON_CAPTION)
                .process(banner.getButtonHref(), TextBanner.BUTTON_HREF)
                .process(banner.getName(), TextBanner.NAME)
                .process(banner.getMulticards(), TextBanner.MULTICARDS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(ImageBanner banner) {
        return new ModelChanges<>(banner.getId(), ImageBanner.class)
                .process(banner.getIsMobileImage(), ImageBanner.IS_MOBILE_IMAGE)
                .process(banner.getHref(), ImageBanner.HREF)
                .processNotNull(banner.getDomain(), ImageBanner.DOMAIN)
                .process(banner.getImageHash(), ImageBanner.IMAGE_HASH)
                .process(banner.getCreativeId(), ImageBanner.CREATIVE_ID)
                .process(banner.getTurboLandingHrefParams(), ImageBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), ImageBanner.TURBO_LANDING_ID)
                .process(banner.getTitle(), ImageBanner.TITLE)
                .process(banner.getTitleExtension(), ImageBanner.TITLE_EXTENSION)
                .process(banner.getBody(), ImageBanner.BODY)
                .process(banner.getLogoImageHash(), ImageBanner.LOGO_IMAGE_HASH)
                .process(banner.getButtonAction(), ImageBanner.BUTTON_ACTION)
                .process(banner.getButtonCaption(), ImageBanner.BUTTON_CAPTION)
                .process(banner.getButtonHref(), ImageBanner.BUTTON_HREF)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpcVideoBanner banner) {
        return new ModelChanges<>(banner.getId(), CpcVideoBanner.class)
                .process(banner.getIsMobileVideo(), CpcVideoBanner.IS_MOBILE_VIDEO)
                .process(banner.getHref(), CpcVideoBanner.HREF)
                .processNotNull(banner.getDomain(), CpcVideoBanner.DOMAIN)
                .process(banner.getCreativeId(), CpcVideoBanner.CREATIVE_ID)
                .process(banner.getTurboLandingHrefParams(), CpcVideoBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), CpcVideoBanner.TURBO_LANDING_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmBanner.class)
                .process(banner.getTitle(), CpmBanner.TITLE)
                .process(banner.getTitleExtension(), CpmBanner.TITLE_EXTENSION)
                .process(banner.getBody(), CpmBanner.BODY)
                .process(banner.getLogoImageHash(), CpmBanner.LOGO_IMAGE_HASH)
                .process(banner.getButtonAction(), CpmBanner.BUTTON_ACTION)
                .process(banner.getButtonCaption(), CpmBanner.BUTTON_CAPTION)
                .process(banner.getButtonHref(), CpmBanner.BUTTON_HREF)
                .process(banner.getHref(), CpmBanner.HREF)
                .processNotNull(banner.getDomain(), CpmBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmBanner.PIXELS)
                .process(banner.getTurboLandingHrefParams(), CpmBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), CpmBanner.TURBO_LANDING_ID)
                .process(banner.getMeasurers(), CpmBanner.MEASURERS)
                .process(banner.getTnsId(), CpmBanner.TNS_ID)
                .process(banner.getAdditionalHrefs(), CpmBanner.ADDITIONAL_HREFS)
                .process(banner.getMulticards(), CpmBanner.MULTICARDS)
                .process(banner.getBigKingImageHash(), CpmBanner.BIG_KING_IMAGE_HASH)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmAudioBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmAudioBanner.class)
                .process(banner.getHref(), CpmAudioBanner.HREF)
                .processNotNull(banner.getDomain(), CpmAudioBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmAudioBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmAudioBanner.PIXELS)
                .process(banner.getMeasurers(), CpmAudioBanner.MEASURERS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmGeoPinBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmGeoPinBanner.class)
                .process(banner.getCreativeId(), CpmGeoPinBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmGeoPinBanner.PIXELS)
                .process(banner.getMeasurers(), CpmGeoPinBanner.MEASURERS)
                .process(banner.getPermalinkId(), CpmGeoPinBanner.PERMALINK_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmOutdoorBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmOutdoorBanner.class)
                .process(banner.getHref(), CpmOutdoorBanner.HREF)
                .processNotNull(banner.getDomain(), CpmOutdoorBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmOutdoorBanner.CREATIVE_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmIndoorBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmIndoorBanner.class)
                .process(banner.getHref(), CpmIndoorBanner.HREF)
                .processNotNull(banner.getDomain(), CpmIndoorBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmIndoorBanner.CREATIVE_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(PerformanceBanner banner) {
        return new ModelChanges<>(banner.getId(), PerformanceBanner.class)
                .process(banner.getCreativeId(), PerformanceBanner.CREATIVE_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(PerformanceBannerMain banner) {
        return new ModelChanges<>(banner.getId(), PerformanceBannerMain.class)
                .process(banner.getLogoImageHash(), PerformanceBannerMain.LOGO_IMAGE_HASH)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(McBanner banner) {
        return new ModelChanges<>(banner.getId(), McBanner.class)
                .process(banner.getHref(), McBanner.HREF)
                .processNotNull(banner.getDomain(), McBanner.DOMAIN)
                .process(banner.getImageHash(), McBanner.IMAGE_HASH)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(MobileAppBanner banner) {
        return new ModelChanges<>(banner.getId(), MobileAppBanner.class)
                .process(banner.getHref(), MobileAppBanner.HREF)
                .processNotNull(banner.getDomain(), MobileAppBanner.DOMAIN)
                .process(banner.getBody(), MobileAppBanner.BODY)
                .process(banner.getImageHash(), MobileAppBanner.IMAGE_HASH)
                .process(banner.getPrimaryAction(), MobileAppBanner.PRIMARY_ACTION)
                .process(banner.getReflectedAttributes(), MobileAppBanner.REFLECTED_ATTRIBUTES)
                .process(banner.getImpressionUrl(), MobileAppBanner.IMPRESSION_URL)
                .process(banner.getTitle(), MobileAppBanner.TITLE)
                .process(banner.getFlags(), MobileAppBanner.FLAGS)
                .process(banner.getCreativeId(), MobileAppBanner.CREATIVE_ID)
                .process(banner.getCalloutIds(), MobileAppBanner.CALLOUT_IDS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(ContentPromotionBanner banner) {
        return new ModelChanges<>(banner.getId(), ContentPromotionBanner.class)
                .process(banner.getContentPromotionId(), ContentPromotionBanner.CONTENT_PROMOTION_ID)
                .process(banner.getTitle(), ContentPromotionBanner.TITLE)
                .process(banner.getBody(), ContentPromotionBanner.BODY)
                .process(banner.getVisitUrl(), ContentPromotionBanner.VISIT_URL)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(DynamicBanner banner) {
        return new ModelChanges<>(banner.getId(), DynamicBanner.class)
                .process(banner.getSitelinksSetId(), DynamicBanner.SITELINKS_SET_ID)
                .process(banner.getBody(), DynamicBanner.BODY)
                .process(banner.getImageHash(), DynamicBanner.IMAGE_HASH)
                .process(banner.getCalloutIds(), DynamicBanner.CALLOUT_IDS)
                .process(banner.getVcardId(), DynamicBanner.VCARD_ID)
                .castModelUp(BannerWithSystemFields.class);
    }
}
