package ru.yandex.direct.grid.processing.service.banner.converter;

import java.util.List;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerCalloutsItem;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerCalloutsReplaceInstruction;
import ru.yandex.direct.grid.core.entity.banner.service.internal.container.GridBannerUpdateInfo;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.banner.mutation.FindAndReplaceAdsCalloutsCacheFilterData;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceCallouts;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceCalloutsAction;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceCalloutsPayloadItem;
import ru.yandex.direct.grid.processing.model.common.GdCachedResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.service.banner.container.FindAndReplaceBannerCalloutsCacheRecordInfo;

import static ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService.convertEmptyToNull;

public class FindAndReplaceBannerCalloutsConverter {

    private FindAndReplaceBannerCalloutsConverter() {
    }

    public static FindAndReplaceBannerCalloutsCacheRecordInfo getCacheRecordInfo(ClientId clientId,
                                                                                 GdFindAndReplaceCallouts input) {
        return new FindAndReplaceBannerCalloutsCacheRecordInfo(clientId.asLong(), input.getCacheKey(),
                new FindAndReplaceAdsCalloutsCacheFilterData()
                        .withAdIds(ImmutableList.copyOf(input.getAdIds()))
                        .withAction(input.getAction())
                        .withReplaceInstruction(input.getReplaceInstruction())
        );
    }

    public static GdCachedResult<GdFindAndReplaceCalloutsPayloadItem> toGdCachedResult(
            int rowSetSize,
            GdValidationResult gdValidationResult, GridBannerUpdateInfo updateInfo) {
        return new GdCachedResult<GdFindAndReplaceCalloutsPayloadItem>()
                .withTotalCount(rowSetSize)
                .withValidationResult(convertEmptyToNull(gdValidationResult))
                .withSuccessCount(updateInfo.getUpdatedBannerCount());
    }

    public static GdResult<GdFindAndReplaceCalloutsPayloadItem> toGdResult(
            List<GdFindAndReplaceCalloutsPayloadItem> rowset,
            @Nullable GdValidationResult validationResult,
            GridBannerUpdateInfo updateInfo) {
        return new GdResult<GdFindAndReplaceCalloutsPayloadItem>()
                .withRowset(rowset)
                .withValidationResult(validationResult)
                .withTotalCount(rowset.size())
                .withSuccessCount(updateInfo.getUpdatedBannerCount());
    }

    public static GdFindAndReplaceCalloutsPayloadItem convertToPayloadItem(GdiFindAndReplaceBannerCalloutsItem item) {
        return new GdFindAndReplaceCalloutsPayloadItem()
                .withAdId(item.getBannerId())
                .withOldCalloutIds(item.getOldCallouts())
                .withNewCalloutIds(item.getNewCallouts());
    }

    public static GdiFindAndReplaceBannerCalloutsReplaceInstruction convertReplaceInstruction(
            GdFindAndReplaceCallouts input) {
        return new GdiFindAndReplaceBannerCalloutsReplaceInstruction()
                .withSearchCalloutIds(input.getReplaceInstruction().getSearch())
                .withReplaceCalloutIds(input.getReplaceInstruction().getReplace())
                .withAction(GdFindAndReplaceCalloutsAction.toSource(input.getAction()));
    }
}

