package ru.yandex.direct.grid.processing.service.banner.converter;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdReplaceDisplayHrefBanner;
import ru.yandex.direct.grid.core.entity.banner.model.GdiReplaceDisplayHrefBanner;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.banner.mutation.FindAndReplaceAdsDisplayHrefCacheFilterData;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdFindAndReplaceAdsDisplayHref;
import ru.yandex.direct.grid.processing.model.common.GdCachedResult;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.service.banner.container.FindAndReplaceBannerDisplayHrefCacheRecordInfo;

import static ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService.convertEmptyToNull;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class FindAndReplaceBannerDisplayHrefConverter {

    private FindAndReplaceBannerDisplayHrefConverter() {
    }

    public static FindAndReplaceBannerDisplayHrefCacheRecordInfo getCacheRecordInfo(ClientId clientId,
                                                                                    GdFindAndReplaceAdsDisplayHref input) {
        return new FindAndReplaceBannerDisplayHrefCacheRecordInfo(clientId.asLong(), input.getCacheKey(),
                new FindAndReplaceAdsDisplayHrefCacheFilterData()
                        .withAdIds(ImmutableList.copyOf(input.getAdIds()))
                        .withNewDisplayHref(input.getNewDisplayHref())
                        .withSearchDisplayHrefs(ifNotNull(input.getSearchDisplayHrefs(), ImmutableList::copyOf))
        );
    }

    /**
     * Сформировать конечный результат операции замены отображаемой ссылки
     */
    public static GdResult<GdReplaceDisplayHrefBanner> createPayload(List<GdReplaceDisplayHrefBanner> rowSetFull,
                                                                     GdValidationResult gdValidationResult, Integer successCount) {
        return new GdResult<GdReplaceDisplayHrefBanner>()
                .withRowset(rowSetFull)
                .withTotalCount(rowSetFull.size())
                .withValidationResult(convertEmptyToNull(gdValidationResult))
                .withSuccessCount(successCount);
    }

    /**
     * Подготовить GdCachedResult, который будет дополнен в cacheService
     */
    public static GdCachedResult<GdReplaceDisplayHrefBanner> preparePreviewPayload(
            int rowSetSize,
            GdValidationResult gdValidationResult) {
        return new GdCachedResult<GdReplaceDisplayHrefBanner>()
                .withTotalCount(rowSetSize)
                .withValidationResult(convertEmptyToNull(gdValidationResult))
                .withSuccessCount(0);
    }

    /**
     * Конвертировать GdiReplaceDisplayHrefBanner в GdReplaceDisplayHrefBanner
     */
    public static List<GdReplaceDisplayHrefBanner> convertGdiToGd(List<GdiReplaceDisplayHrefBanner> gdiBanner) {
        return gdiBanner.stream().map(
                gdi -> new GdReplaceDisplayHrefBanner()
                        .withBannerId(gdi.getBannerId())
                        .withNewDisplayHref(gdi.getNewDisplayHref())
                        .withSourceDisplayHref(gdi.getSourceDisplayHref())
        ).collect(Collectors.toList());
    }
}
