package ru.yandex.direct.grid.processing.service.banner.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdAdsMassActionPayload;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.result.ResultState;

import static java.util.Collections.emptyList;

@ParametersAreNonnullByDefault
public class MassActionsDataConverter {

    public static GdAdsMassActionPayload getGdBannerMassActionPayload(MassResult<Long> massResult,
                                                                      List<Long> initialAdIds,
                                                                      @Nullable GdValidationResult vr,
                                                                      boolean hasOutput) {
        //В некоторых ситуациях для broken операций такое может быть
        if (massResult.getResult() == null) {
            return new GdAdsMassActionPayload()
                    .withTotalCount(initialAdIds.size())
                    .withSuccessCount(0)
                    .withProcessedAdIds(emptyList())
                    .withSkippedAdIds(initialAdIds)
                    .withValidationResult(vr);
        }

        Map<Boolean, List<Long>> actionResult = EntryStream
                .zip(massResult.getResult(), initialAdIds)
                .mapKeys(result -> result.getState() == ResultState.SUCCESSFUL)
                .grouping();

        List<Long> resultAdIds = null;
        if (hasOutput) {
            resultAdIds = StreamEx.of(massResult.getResult())
                    .filter(result -> result.getState() == ResultState.SUCCESSFUL)
                    .map(Result::getResult)
                    .toList();
        }

        return new GdAdsMassActionPayload()
                .withTotalCount(massResult.getSuccessfulObjectsCount() + massResult.getUnsuccessfulObjectsCount())
                .withSuccessCount(massResult.getSuccessfulObjectsCount())
                .withProcessedAdIds(actionResult.getOrDefault(Boolean.TRUE, emptyList()))
                .withSkippedAdIds(actionResult.getOrDefault(Boolean.FALSE, emptyList()))
                .withResultAdIds(resultAdIds)
                .withValidationResult(vr);
    }
}
