package ru.yandex.direct.grid.processing.service.banner.converter;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdAddSitelink;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdAddSitelinkSet;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdUpdateSitelink;
import ru.yandex.direct.grid.processing.model.banner.mutation.GdUpdateTurbolanding;

import static ru.yandex.direct.core.entity.uac.UacCommonUtils.getHrefWithTrackingParams;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@SuppressWarnings("WeakerAccess")
@ParametersAreNonnullByDefault
public class SitelinkConverter {
    public static SitelinkSet toSitelinkSet(@Nullable List<GdUpdateSitelink> gdSitelinks) {
        if (gdSitelinks == null) {
            return null;
        }
        return new SitelinkSet()
                .withSitelinks(mapList(gdSitelinks, SitelinkConverter::toCoreSitelink));
    }

    private static Sitelink toCoreSitelink(GdUpdateSitelink gdSitelink) {
        return new Sitelink()
                .withTitle(gdSitelink.getTitle())
                .withDescription(gdSitelink.getDescription())
                .withHref(gdSitelink.getHref())
                .withTurboLandingId(toCoreTurbolandingId(gdSitelink));
    }

    //todo mariachernova: Временный метод для поддержки двух вариантов. Убрать после выкладки DIRECT-89309
    private static Long toCoreTurbolandingId(GdUpdateSitelink gdSitelink) {
        if (gdSitelink.getTurbolandingId() != null) {
            return gdSitelink.getTurbolandingId();
        }
        return ifNotNull(gdSitelink.getTurbolanding(), GdUpdateTurbolanding::getId);
    }

    //add sitelinks
    public static SitelinkSet toCoreSet(GdAddSitelinkSet gdAddSitelinkSet) {
        return toCoreSet(gdAddSitelinkSet, null);
    }

    public static SitelinkSet toCoreSet(GdAddSitelinkSet gdAddSitelinkSet, @Nullable String trackingParams) {
        return new SitelinkSet()
                .withSitelinks(mapList(gdAddSitelinkSet.getSitelinks(),
                        gdAddSitelink -> toCoreLink(gdAddSitelink, trackingParams)));
    }

    private static Sitelink toCoreLink(GdAddSitelink gdAddSitelink, @Nullable String trackingParams) {
        String href = gdAddSitelink.getHref() == null ? null :
                getHrefWithTrackingParams(gdAddSitelink.getHref(), trackingParams);
        return new Sitelink()
                .withTitle(gdAddSitelink.getTitle())
                .withDescription(gdAddSitelink.getDescription())
                .withHref(href)
                .withTurboLandingId(gdAddSitelink.getTurbolandingId());
    }

}
