package ru.yandex.direct.grid.processing.service.bidmodifier;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import org.dataloader.DataLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.bidmodifier.GdBidModifier;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки клиентов, относящихся к проекту
 *
 * @see GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class BidModifierByCampaignIdsDataLoader extends GridBatchingDataLoader<Long, List<GdBidModifier>> {

    @Autowired
    public BidModifierByCampaignIdsDataLoader(BidModifierDataService bidModifierDataService,
                                              GridContextProvider gridContextProvider) {
        dataLoader = dataLoader(keys -> {
            GdClientInfo queriedClient = gridContextProvider.getGridContext().getQueriedClient();
            checkNotNull(queriedClient, "queriedClient should be set in gridContext");

            Map<Long, List<GdBidModifier>> bidModifiersByCampaignIds = bidModifierDataService
                    .getBidModifiersByCampaignIds(queriedClient.getShard(), new HashSet<>(keys));
            return CompletableFuture.completedFuture(mapList(keys, bidModifiersByCampaignIds::get));
        });
    }

}
