package ru.yandex.direct.grid.processing.service.bidmodifier;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;

import ru.yandex.direct.grid.model.campaign.GdCampaign;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.model.bidmodifier.GdBidModifier;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;

/**
 * Сервис, возвращающий данные о корретировках ставок
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class BidModifierGraphQlService {
    public static final String AD_GROUP_BID_MODIFIERS_RESOLVER_NAME = "bidModifiers";
    public static final String CAMPAIGN_BID_MODIFIERS_RESOLVER_NAME = "bidModifiers";

    private final BidModifierByAdGroupIdsDataLoader bidModifierByAdgroupIdsDataLoader;
    private final BidModifierByCampaignIdsDataLoader bidModifierByCampaignIdsDataLoader;

    public BidModifierGraphQlService(BidModifierByAdGroupIdsDataLoader bidModifierByAdgroupIdsDataLoader,
                                     BidModifierByCampaignIdsDataLoader bidModifierByCampaignIdsDataLoader) {
        this.bidModifierByAdgroupIdsDataLoader = bidModifierByAdgroupIdsDataLoader;
        this.bidModifierByCampaignIdsDataLoader = bidModifierByCampaignIdsDataLoader;
    }

    /**
     * GraphQL подзапрос. Получает информацию о корректировках на группу объявлений клиента,
     * полученную из контекста выполнения запроса
     */
    @Nullable
    @GraphQLQuery(name = AD_GROUP_BID_MODIFIERS_RESOLVER_NAME)
    public CompletableFuture<List<@GraphQLNonNull GdBidModifier>> getAdGroupBidModifierContext(
            @GraphQLContext GdAdGroup gdAdGroup) {
        return bidModifierByAdgroupIdsDataLoader.get().load(gdAdGroup.getId());
    }

    /**
     * GraphQL подзапрос. Получает информацию о корректировках на кампанию клиента,
     * полученную из контекста выполнения запроса
     */
    @Nullable
    @GraphQLQuery(name = CAMPAIGN_BID_MODIFIERS_RESOLVER_NAME)
    public CompletableFuture<List<@GraphQLNonNull GdBidModifier>> getCampaignBidModifierContext(
            @GraphQLContext GdCampaign gdCampaign) {
        return bidModifierByCampaignIdsDataLoader.get().load(gdCampaign.getId());
    }
}
