package ru.yandex.direct.grid.processing.service.brandlift;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.campaign.GdGetBrandSurveys;
import ru.yandex.direct.grid.processing.model.campaign.GdGetBrandSurveysPayload;
import ru.yandex.direct.grid.processing.model.client.GdClient;

/**
 * Сервис, возвращающий данные об опросах взгляда клиента
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class BrandSurveysGraphQlService {

    private final BrandSurveysInfoService brandSurveysInfoService;

    public BrandSurveysGraphQlService(BrandSurveysInfoService brandSurveysInfoService) {
        this.brandSurveysInfoService = brandSurveysInfoService;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "getBrandSurveys")
    public GdGetBrandSurveysPayload getBrandSurveys(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLContext GdClient client,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdGetBrandSurveys input) {
        var clientId = ClientId.fromLong(client.getInfo().getId());
        return brandSurveysInfoService.getBrandSurveysWithCampaigns(clientId, context, input);
    }
}
