package ru.yandex.direct.grid.processing.service.cache;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkState;

/**
 * Наследники этого класса описывают экземпляр какешированного грида.
 *
 * @param <R> - класс строки грида
 * @param <F> - класс, содержащий все фильтры
 * @param <D> - класс, представляющий объект кеширований - контекст GraphQl
 */
@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, fieldVisibility = JsonAutoDetect.Visibility.ANY)
public abstract class CacheRecordInfo<R, F extends CacheFilterData, D extends CachedGridData<R>> {
    @JsonProperty("clientId")
    private long clientId;
    @JsonProperty("key")
    private String key;
    @JsonProperty("filter")
    private F filter;
    @JsonProperty("totalSize")
    private int totalSize;
    @JsonProperty("chunkSize")
    private int chunkSize;
    @JsonProperty("data")
    private D data;

    public CacheRecordInfo() {
    }

    public CacheRecordInfo(long clientId, String key, F filter) {
        this.clientId = clientId;
        this.key = key;
        this.filter = filter;
    }

    public CacheRecordInfo(long clientId, String key, F filter, int totalSize, int chunkSize, D data) {
        this(clientId, key, filter);

        this.totalSize = totalSize;
        this.chunkSize = chunkSize;
        this.data = data;
    }

    @SuppressWarnings("unchecked")
    public Class<R> getRowClass() {
        // трюк подсмотрен в TypeReference
        Type superClass = getClass().getGenericSuperclass();
        return (Class<R>) ((ParameterizedType) superClass).getActualTypeArguments()[0];
    }

    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public F getFilter() {
        return filter;
    }

    public void setFilter(F filter) {
        this.filter = filter;
    }

    public int getTotalSize() {
        return totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public int getChunkSize() {
        return chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public D getData() {
        return data;
    }

    public void setData(D data) {
        this.data = data;
    }

    public String infoKey() {
        checkState(key != null);
        return String.format("{%d}.%s.info", clientId, key);
    }

    public String chunkKey(int chunkIndex) {
        checkState(key != null);
        return String.format("{%d}.%s.chunks.%d", clientId, key, chunkIndex);
    }
}
