Кеширование данных для Гридов
=============================

При первонаячальной загрузке страницы фронтенд выбирает первые N строк грида, загружая остальные по требованию.
Чтобы скролинг работал быстро, на стороне бекенда кешируется полный набор данных (10_000 строк) и возвращается на уровне контекстов cacheKey - идентификатор, по которому можно обращаться к данным.
При этом важно, чтобы все остальные параметры выборки (фильтры/сортировки) оставались прежними отличие допускается только в LimitOffset параметра, иначе бекэнд сделает новый запрос с новыми фильтрами, и сгенерирует новый cacheKey.
Если данные в кеше протухают (время жизни 10 минут), то бекенд делает новый запрос в YT и кеширует его, возвращая новый cacheKey.

Технические подробности
-----------------------

Точка входа в кеширование - GridCacheService, этот  сервис умеет проверять наличие данных в кеше и сохранять результат в кеш. 

Для того, чтобы контекст кешировался, он должен реализовывать интерфейс CachedGridData. Все фильтры/сортировки должны сохраняться в объект, реализующий CacheFilterData. Кешируемый контекст и строки должны поддерживать сериализацию в json.

Данные для кеша сериализуются в json, жмутся gzip и сохраняются в Redis.

На текущий момент, отдельной очистки кеша нет, расчитываем на вытеснение из redis и expire, возможно со временем нужно будет реализовать логику сохранения только N ключей на ClientID.

Если меняется что-то связанное с кешированием - кешируемые объекты, компрессор, схема кеширования - нужно менять префикс ключа - GridCacheStorageHelper.KEY_PREFIX

В кеше данные хранятся в следующих ключах:
- `$ClientID.$cacheKey.info` - объект с сериализованными фильтрами и прочей информацией о закешированнй записи (CacheRecordInfo)
- `$ClientID.$cacheKey.chunk.$idx` - чанки массива строк. Массив строк бъётся на куски по GridCacheService.ROWSET_CHUNK_SIZE строк и записывается в кеш по-отдельности. это сделано, чтобы с одной стороны не нужно было на каждый запрос десериализовывать все строки, а с другой стороны не писать каждую строку в отдельный ключ 

Для кеширования новой сущности нужно:
- сделать так, чтобы контекст реализовывал `ru.yandex.direct.grid.processing.service.cache.CachedGridData<R>`
- сделать pojo, расширяющий CacheFilterData, для хранения всех фильтров сортировок вместе
- сделать класс - наследник CacheRecordInfo - для сохранения типов кешируемых сужностей 

#### Почему Json?
С ним все умеют работать, библиотека быстрая, не нужно генерировать отдельные DTO, умеет работать с интерфейсами.

#### Почему Redis
Общий кеш как сервис в Яндексе сейчас только один, CaaS, но сейчас у него меняется команда, он будет переписываться
и судьба его туманна. С Redis-Cluster мы работать уже умеем.

Скорее всего для запуска в прод понадобится поднять отдельный кластер, с другой политикой сохранности данных, 
но пробовать можем на текущем. 

К сожалению, JedisCluster никак не умеет pipelined (для сохранения всех ключей за один раз), поэтому используется lettuce.
