package ru.yandex.direct.grid.processing.service.cache.storage;

import java.time.Duration;
import java.util.Optional;

/**
 * Интерфейс стораджа, для хранения кеша гридов
 */
public interface GridCacheStorage {
    /**
     * Прочитать ключ
     */
    Optional<String> get(String key);

    /**
     * Сохранить ключ-значение с определённым временем жизни
     */
    void set(String key, byte[] data, Duration expire);
}
