package ru.yandex.direct.grid.processing.service.cache.storage;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

/**
 * Локальное кеширование грида, только для тестов
 */
public class GuavaGridCacheStorage implements GridCacheStorage {
    private final Cache<String, String> cache = CacheBuilder.newBuilder()
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .maximumSize(1_000)
            .build();

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(cache.getIfPresent(key));
    }

    @Override
    public void set(String key, byte[] data, Duration expire) {
        cache.put(key, new String(data, StandardCharsets.UTF_8));
    }
}
