package ru.yandex.direct.grid.processing.service.cache.util;

import java.util.concurrent.ThreadLocalRandom;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * генератор случайных строк, которые можно использовать в качестве ключей кеша
 */
public class CacheKeyGenerator {
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String DIGITS = "0123456789";

    public static final String ALPHABET = LETTERS.toLowerCase() + LETTERS.toUpperCase() + DIGITS;
    private final int keyLength;
    private static final ThreadLocalRandom RND = ThreadLocalRandom.current();


    public CacheKeyGenerator(int keyLength) {
        checkArgument(keyLength >= 10);
        this.keyLength = keyLength;
    }

    public String generate() {
        StringBuilder sb = new StringBuilder(keyLength);
        for (int i = 0; i < keyLength; i++) {
            sb.append(ALPHABET.charAt(RND.nextInt(ALPHABET.length())));
        }
        return sb.toString();
    }
}
