package ru.yandex.direct.grid.processing.service.cache.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

import ru.yandex.direct.grid.processing.model.GdLimitOffset;
import ru.yandex.direct.multitype.entity.LimitOffset;

import static com.google.common.base.Preconditions.checkArgument;

public class CacheUtils {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_OFFSET = 0;

    private CacheUtils() {
    }

    public static LimitOffset normalizeLimitOffset(@Nullable GdLimitOffset limitOffset) {
        return new LimitOffset(
                Optional.ofNullable(limitOffset).map(GdLimitOffset::getLimit).orElse(DEFAULT_LIMIT),
                Optional.ofNullable(limitOffset).map(GdLimitOffset::getOffset).orElse(DEFAULT_OFFSET)
        );
    }

    /**
     * @param limitOffset
     * @param chunkSize
     * @param totalSize
     * @return
     */
    public static List<ChunkRef> calculateChunkRefs(LimitOffset limitOffset, int chunkSize, int totalSize) {
        checkArgument(chunkSize > 0);
        checkArgument(totalSize >= 0);
        if (limitOffset.limit() == 0 || limitOffset.offset() >= totalSize) {
            return Collections.emptyList();
        }

        int lastItemIndex = Integer.min(limitOffset.offset() + limitOffset.limit(), totalSize) - 1;

        int firstChunk = limitOffset.offset() / chunkSize;
        int lastChunk = lastItemIndex / chunkSize;
        List<ChunkRef> ret = new ArrayList<>(lastChunk - firstChunk + 1);
        for (int i = firstChunk; i <= lastChunk; i++) {
            ret.add(new ChunkRef(i,
                    i == firstChunk ? limitOffset.offset() % chunkSize : 0,
                    i == lastChunk ? lastItemIndex % chunkSize + 1 : chunkSize
            ));
        }
        return ret;
    }
}
