package ru.yandex.direct.grid.processing.service.cache.util;

/**
 * Простой объект, указывающий на номер чанка и диапазон строк внутри него
 */
public class ChunkRef {
    private final int idx;
    private final int begin;
    private final int end;

    public ChunkRef(int idx, int begin, int end) {
        this.idx = idx;
        this.begin = begin;
        this.end = end;
    }

    public int idx() {
        return idx;
    }

    public int begin() {
        return begin;
    }

    public int end() {
        return end;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ChunkRef chunkRef = (ChunkRef) o;

        if (idx != chunkRef.idx) {
            return false;
        }
        if (begin != chunkRef.begin) {
            return false;
        }
        return end == chunkRef.end;
    }

    @Override
    public int hashCode() {
        int result = idx;
        result = 31 * result + begin;
        result = 31 * result + end;
        return result;
    }
}
