package ru.yandex.direct.grid.processing.service.campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.abac.Attribute;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedPageIds;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLift;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisallowedPageIds;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository;
import ru.yandex.direct.grid.processing.service.attributes.AttributeResolverService;
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler;
import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public class CampaignConverterContext {
    public static CampaignConverterContext create(AttributeResolverService attributeResolverService,
            SspPlatformsRepository sspPlatformsRepository, HostingsHandler hostingsHandler) {
        List<ModelProperty> shouldProcessProperties = new ArrayList<>();
        if (attributeResolverService.resolve(Attribute.CAN_EDIT_CAMPAIGN_CONTENT_LANGUAGE_BLOCK)) {
            shouldProcessProperties.add(CampaignWithContentLanguage.CONTENT_LANGUAGE);
        }
        if (attributeResolverService.resolve(Attribute.OPERATOR_HAS_SET_CAMPAIGN_ALLOWED_PAGE_IDS_FEATURE)) {
            shouldProcessProperties.add(CampaignWithAllowedPageIds.ALLOWED_PAGE_IDS);
        }
        if (attributeResolverService.resolve(Attribute.OPERATOR_HAS_SET_CAMPAIGN_DISALLOWED_PAGE_IDS_FEATURE)) {
            shouldProcessProperties.add(CampaignWithDisallowedPageIds.DISALLOWED_PAGE_IDS);
        }

        if (attributeResolverService.resolve(Attribute.CLIENT_CAN_CREATE_EXPERIMENT)) {
            shouldProcessProperties.add(CampaignWithExperiments.AB_SEGMENT_RETARGETING_CONDITION_ID);
            shouldProcessProperties.add(CampaignWithExperiments.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID);
            shouldProcessProperties.add(CampaignWithExperiments.AB_SEGMENT_GOAL_IDS);
            shouldProcessProperties.add(CampaignWithExperiments.SECTION_IDS);

            shouldProcessProperties.add(CampaignWithBrandLift.AB_SEGMENT_GOAL_IDS);
            shouldProcessProperties.add(CampaignWithBrandLift.SECTION_IDS);
        }
        if (attributeResolverService.resolve(Attribute.CLIENT_CAN_CREATE_BRAND_LIFT)) {
            shouldProcessProperties.add(CampaignWithBrandLift.BRAND_SURVEY_ID);
            shouldProcessProperties.add(CampaignWithBrandLift.BRAND_SURVEY_NAME);
        }
        return new CampaignConverterContext()
                .withSspPlatforms(sspPlatformsRepository.getAllSspPlatforms())
                .withShouldProcessProperties(shouldProcessProperties)
                .withHostingsHandler(hostingsHandler);
    }

    private List<String> sspPlatforms;
    private List<ModelProperty> shouldProcessProperties;
    private HostingsHandler hostingsHandler;

    public List<String> getSspPlatforms() {
        return sspPlatforms;
    }

    public CampaignConverterContext withSspPlatforms(List<String> sspPlatforms) {
        this.sspPlatforms = sspPlatforms;
        return this;
    }

    public List<ModelProperty> getShouldProcessProperties() {
        return shouldProcessProperties;
    }

    public CampaignConverterContext withShouldProcessProperties(List<ModelProperty> shouldProcessProperties) {
        this.shouldProcessProperties = shouldProcessProperties;
        return this;
    }

    public HostingsHandler getHostingsHandler() {
        return hostingsHandler;
    }

    public void setHostingsHandler(HostingsHandler hostingsHandler) {
        this.hostingsHandler = hostingsHandler;
    }

    public CampaignConverterContext withHostingsHandler(HostingsHandler hostingsHandler) {
        this.hostingsHandler = hostingsHandler;
        return this;
    }
}
