package ru.yandex.direct.grid.processing.service.campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.model.campaign.GdCampaign;
import ru.yandex.direct.grid.model.campaign.GdCampaignAction;
import ru.yandex.direct.grid.processing.model.campaign.GdCampaignsFeatures;
import ru.yandex.direct.grid.processing.util.AggregationStatsCalculator;

import static ru.yandex.direct.grid.model.campaign.GdCampaignPrimaryStatusDesc.IS_NOT_RECOVERED;

@ParametersAreNonnullByDefault
class CampaignFeatureCalculator {

    static final AggregationStatsCalculator<GdCampaign, GdCampaignsFeatures> FEATURE_CALCULATOR =
            AggregationStatsCalculator.<GdCampaign, GdCampaignsFeatures>builder(GdCampaignsFeatures::new)
                    .valuesSet(GdCampaignsFeatures::setCampaignTypes, GdCampaign::getType)
                    .hasValue(GdCampaignsFeatures::setHasCurrencyArchivedCampaigns,
                            GdCampaign::getStatus, s -> s.getPrimaryStatusDesc() == IS_NOT_RECOVERED)
                    .valuesCount(GdCampaignsFeatures::setCanBeEditedMetrikaCountersCampaignsCount,
                            campaign -> campaign.getAccess().getActions(),
                            actions -> actions.contains(GdCampaignAction.EDIT_METRICA_COUNTERS))
                    .valuesCount(GdCampaignsFeatures::setCanResetCampaignFlightStatusApproveCount,
                            campaign -> campaign.getAccess().getActions(),
                            actions -> actions.contains(GdCampaignAction.RESET_FLIGHT_STATUS_APPROVE))
                    .build();

    private CampaignFeatureCalculator() {
    }
}
