package ru.yandex.direct.grid.processing.service.campaign

import org.apache.commons.lang3.ObjectUtils.max
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum
import ru.yandex.direct.grid.core.entity.model.campaign.GdiCampaignStats
import ru.yandex.direct.grid.model.campaign.GdCampaign
import ru.yandex.direct.grid.model.campaign.strategy.GdStrategyType
import ru.yandex.direct.grid.processing.model.campaign.GdConversionStrategyLearningStatus
import java.time.LocalDate

class ConversionStrategyWithCampaignLearningData(
    val campaign: GdCampaign,
    val lastRestartBidderTime: LocalDate?,
    strategyGoalId: Long?,
    stats: GdiCampaignStats,
    lastDayStats: GdiCampaignStats
) : ConversionStrategyLearningData(strategyGoalId, stats, lastDayStats) {

    override fun isRevenueModelStrategy(): Boolean =
        campaign.flatStrategy.strategyType == GdStrategyType.CRR

    override fun restartOrStartDate(): LocalDate =
        max(lastRestartBidderTime, startDate())

    override fun startDate(): LocalDate = campaign.startDate

    override fun getStatus(now: LocalDate): GdConversionStrategyLearningStatus {
        if (!isCampaignCanBeLearned(campaign)) {
            return GdConversionStrategyLearningStatus.NOT_LEARNED
        }
        return super.getStatus(now)
    }

    private fun isCampaignCanBeLearned(campaign: GdCampaign): Boolean {
        val selfStatus = campaign.aggregatedStatusInfo.status
        return GdSelfStatusEnum.allRun().contains(selfStatus) || GdSelfStatusEnum.allPause().contains(selfStatus)
    }
}

