package ru.yandex.direct.grid.processing.service.campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorFacade;

/**
 * Сервис, предназначенный для подготовки описаний стратегий
 */
@Service
@ParametersAreNonnullByDefault
public class GridCampaignStrategyService {
    private final GdStrategyExtractorFacade strategyExtractorFacade;

    @Autowired
    public GridCampaignStrategyService(
            GdStrategyExtractorFacade strategyExtractorFacade) {
        this.strategyExtractorFacade = strategyExtractorFacade;
    }

    /**
     * Получить плоское описание стратегии кампании по ее внутреннему представлению
     */
    @Deprecated
    public GdCampaignFlatStrategy extractFlatStrategy(GdiCampaignStrategyGroup strategyGroup) {
        return strategyExtractorFacade.extractFlatStrategy(strategyGroup);
    }

    /**
     * Получить плоское описание стратегии кампании по ее внутреннему представлению
     */
    public GdCampaignFlatStrategy extractStrategy(GdiCampaignStrategyGroup strategyGroup) {
        return strategyExtractorFacade.extractStrategy(strategyGroup);
    }
}
