package ru.yandex.direct.grid.processing.service.campaign;

import java.util.Locale;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.region.RegionDesc;
import ru.yandex.direct.grid.processing.model.placement.GdRegionDesc;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.localization.LocalizationMapper;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.Region;

@ParametersAreNonnullByDefault
@Component
public class RegionDescriptionLocalizer {
    private static final LocalizationMapper<RegionDesc, GdRegionDesc> regionDescToGdRegionDescMapper =
            LocalizationMapper.builder()
                    .addEnTranslation(RegionDesc::getNameEn)
                    .addRuTranslation(RegionDesc::getNameRu)
                    .addUaTranslation(RegionDesc::getNameUa)
                    .addTrTranslation(RegionDesc::getNameTr)
                    .translateTo(GdRegionDesc::setName)
                    .copyBy(regionDesc -> new GdRegionDesc().withId(regionDesc.getId()))
                    .withDefaultLanguage(Language.EN)
                    .build();

    public GdRegionDesc localize(Long regionId, GeoTree geoTree) {
        Region region = geoTree.getRegion(regionId);
        RegionDesc rd = RegionDesc.fromRegion(region);
        return localize(rd);
    }

    public GdRegionDesc localize(RegionDesc rd) {
        Locale locale = LocaleContextHolder.getLocale();
        return regionDescToGdRegionDescMapper.localize(rd, locale);
    }
}
