package ru.yandex.direct.grid.processing.service.campaign;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

import static com.google.common.base.Preconditions.checkNotNull;

@Component
@ParametersAreNonnullByDefault
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class VcardDataLoader extends GridBatchingDataLoader<Long, Vcard> {
    public VcardDataLoader(GridContextProvider gridContextProvider,
                           VcardService vcardService) {
        this.dataLoader = mappedDataLoader(gridContextProvider, getBatchLoadFunction(vcardService));
    }

    private MappedBatchLoaderWithContext<Long, Vcard> getBatchLoadFunction(VcardService vcardService) {
        return (campaignsIds, environment) -> {
            GridGraphQLContext context = environment.getContext();
            User subjectUser = context.getSubjectUser();
            checkNotNull(subjectUser, "subjectUser should be set in gridContext");
            Map<Long, Vcard> vcardsById = vcardService.getCommonVcardByCampaignId(
                    UidAndClientId.of(subjectUser.getChiefUid(), subjectUser.getClientId()),
                    campaignsIds);

            Map<Long, Vcard> vcardByCampaignId = StreamEx.of(campaignsIds)
                    .mapToEntry(Function.identity(), vcardsById::get)
                    .nonNullValues()
                    .toMap();

            return CompletableFuture.completedFuture(vcardByCampaignId);
        };
    }
}
