package ru.yandex.direct.grid.processing.service.campaign.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCampaignUnion;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCampaigns;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.grid.processing.service.campaign.converter.type.CampaignConverterFacade;
import ru.yandex.direct.grid.processing.service.campaign.converter.type.CampaignConverterSupport;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class AddCampaignMutationConverter {
    public static List<? extends BaseCampaign> toCoreCampaigns(
            GdAddCampaigns gdAddCampaigns, CampaignConverterContext converterContext) {
        List<GdAddAbstractCampaign> gdAddAbstractCampaigns = toGdAddAbstractCampaign(gdAddCampaigns);
        return campaignsToCoreCampaign(gdAddAbstractCampaigns, converterContext);
    }

    private static List<GdAddAbstractCampaign> toGdAddAbstractCampaign(GdAddCampaigns gdAddCampaigns) {
        return mapList(gdAddCampaigns.getCampaignAddItems(),
                AddCampaignMutationConverter::getAddCampaignFromUnion);
    }

    private static GdAddAbstractCampaign getAddCampaignFromUnion(GdAddCampaignUnion gdAddCampaignUnion) {
        return (GdAddAbstractCampaign) StreamEx.of(GdAddCampaignUnion.allModelProperties())
                .map(x -> x.getRaw(gdAddCampaignUnion))
                .nonNull()
                .findAny()
                .orElseThrow();
    }

    private static List<BaseCampaign> campaignsToCoreCampaign(
            List<GdAddAbstractCampaign> campaigns, CampaignConverterContext converterContext) {
        return mapList(campaigns, c -> campaignToCoreCampaign(c, converterContext));
    }

    public static BaseCampaign campaignToCoreCampaign(
            GdAddAbstractCampaign gdAddAbstractCampaign, CampaignConverterContext converterContext) {
        Class<? extends GdAddAbstractCampaign> campaignClass = gdAddAbstractCampaign.getClass();
        CampaignConverterSupport support = CampaignConverterFacade.getSupportByAddType(campaignClass, converterContext);
        return support.toCoreCampaign(gdAddAbstractCampaign);
    }
}
