package ru.yandex.direct.grid.processing.service.campaign.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaignUnion;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaigns;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaignsTimeTargeting;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.grid.processing.service.campaign.converter.type.CampaignConverterFacade;
import ru.yandex.direct.grid.processing.service.campaign.converter.type.CampaignConverterSupport;
import ru.yandex.direct.libs.timetarget.TimeTarget;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class UpdateCampaignMutationConverter {
    private UpdateCampaignMutationConverter() {
    }

    public static List<? extends ModelChanges<? extends BaseCampaign>> gdUpdateCampaignsToCoreModelChanges(
            GdUpdateCampaigns gdUpdateCampaigns, CampaignConverterContext converterContext) {
        List<GdUpdateAbstractCampaign> gdUpdateAbstractCampaigns = toGdUpdateAbstractCampaign(gdUpdateCampaigns);
        return campaignsToCoreModelChanges(gdUpdateAbstractCampaigns, converterContext);
    }

    public static List<ModelChanges<CommonCampaign>> gdUpdateTimeTargetToCoreModelChanges(
            @GraphQLNonNull GdUpdateCampaignsTimeTargeting gdUpdateCampaignsTimeTargeting) {
        Long timeZoneId = gdUpdateCampaignsTimeTargeting.getTimeTarget().getIdTimeZone();
        TimeTarget timeTarget = CampaignDataConverter.toTimeTarget(gdUpdateCampaignsTimeTargeting.getTimeTarget());

        return mapList(gdUpdateCampaignsTimeTargeting.getCampaignIds(),
                cid -> new ModelChanges<>(cid, CommonCampaign.class)
                        .processNotNull(timeTarget, CommonCampaign.TIME_TARGET)
                        .processNotNull(timeZoneId, CommonCampaign.TIME_ZONE_ID));
    }

    private static List<GdUpdateAbstractCampaign> toGdUpdateAbstractCampaign(GdUpdateCampaigns gdUpdateCampaigns) {
        return mapList(gdUpdateCampaigns.getCampaignUpdateItems(),
                UpdateCampaignMutationConverter::getUpdateCampaignFromUnion);
    }

    private static GdUpdateAbstractCampaign getUpdateCampaignFromUnion(GdUpdateCampaignUnion gdUpdateCampaignUnion) {
        return (GdUpdateAbstractCampaign) StreamEx.of(GdUpdateCampaignUnion.allModelProperties())
                .map(x -> x.getRaw(gdUpdateCampaignUnion))
                .nonNull()
                .findAny()
                .orElseThrow();
    }

    private static List<ModelChanges<BaseCampaign>> campaignsToCoreModelChanges(
            List<GdUpdateAbstractCampaign> campaigns, CampaignConverterContext converterContext) {
        return mapList(campaigns, c -> campaignToCoreModelChanges(c, converterContext));
    }

    private static ModelChanges<BaseCampaign> campaignToCoreModelChanges(
            GdUpdateAbstractCampaign gdUpdateAbstractCampaign, CampaignConverterContext converterContext) {
        Class<? extends GdUpdateAbstractCampaign> campaignClass = gdUpdateAbstractCampaign.getClass();
        CampaignConverterSupport support = CampaignConverterFacade.getSupportByUpdateType(campaignClass,
                converterContext);
        BaseCampaign baseCampaign = support.toCoreCampaign(gdUpdateAbstractCampaign);
        return support.toModelChanges(baseCampaign);
    }

}
