package ru.yandex.direct.grid.processing.service.campaign.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign;
import ru.yandex.direct.core.entity.campaign.model.McBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.grid.model.campaign.facelift.GdBudgetDisplayFormat;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaignsStrategy;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class UpdateCampaignsStrategyConverter {
    private UpdateCampaignsStrategyConverter() {
    }

    public static List<? extends ModelChanges<? extends BaseCampaign>> toCoreModelChanges(
            GdUpdateCampaignsStrategy input,
            Map<Long, List<Long>> campaignIdToCounterIds) {
        return mapList(input.getCampaignIds(), id -> itemToModelChanges(id, input, campaignIdToCounterIds.get(id)));
    }

    private static ModelChanges<? extends BaseCampaign> itemToModelChanges(Long cid,
                                                                           GdUpdateCampaignsStrategy input,
                                                                           @Nullable List<Long> counterIds) {
        switch (input.getType()) {
            case TEXT:
                return new ModelChanges<>(cid, TextCampaign.class)
                        .processNotNull(input.getIsSimplifiedStrategyViewEnabled(),
                                TextCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                        .process(toCampaignStrategy(input.getBiddingStrategy()), TextCampaign.STRATEGY)
                        .process(setScaleForCore(input.getDayBudget()), TextCampaign.DAY_BUDGET)
                        .process(toCampaignDayBudgetShowMode(input.getDayBudgetShowMode()),
                                TextCampaign.DAY_BUDGET_SHOW_MODE)
                        .process(toCampaignAttributionModel(input.getAttributionModel()),
                                TextCampaign.ATTRIBUTION_MODEL)
                        .process(input.getContextLimit(), TextCampaign.CONTEXT_LIMIT)
                        .process(input.getEnableCpcHold(), TextCampaign.ENABLE_CPC_HOLD)
                        .process(GdBudgetDisplayFormat.toSource(input.getBudgetDisplayFormat()),
                                TextCampaign.BUDGET_DISPLAY_FORMAT)
                        .processNotNull(counterIds, TextCampaign.METRIKA_COUNTERS);
            case DYNAMIC:
                return new ModelChanges<>(cid, DynamicCampaign.class)
                        .processNotNull(input.getIsSimplifiedStrategyViewEnabled(),
                                DynamicCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                        .process(toCampaignStrategy(input.getBiddingStrategy()), DynamicCampaign.STRATEGY)
                        .process(setScaleForCore(input.getDayBudget()), DynamicCampaign.DAY_BUDGET)
                        .process(toCampaignDayBudgetShowMode(input.getDayBudgetShowMode()),
                                DynamicCampaign.DAY_BUDGET_SHOW_MODE)
                        .process(toCampaignAttributionModel(input.getAttributionModel()),
                                DynamicCampaign.ATTRIBUTION_MODEL)
                        .process(input.getEnableCpcHold(), DynamicCampaign.ENABLE_CPC_HOLD)
                        .processNotNull(counterIds, DynamicCampaign.METRIKA_COUNTERS);
            case PERFORMANCE:
                return new ModelChanges<>(cid, SmartCampaign.class)
                        .processNotNull(input.getIsSimplifiedStrategyViewEnabled(),
                                SmartCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                        .process(toCampaignStrategy(input.getBiddingStrategy()), SmartCampaign.STRATEGY)
                        .process(toCampaignAttributionModel(input.getAttributionModel()),
                                SmartCampaign.ATTRIBUTION_MODEL)
                        .process(input.getContextLimit(), SmartCampaign.CONTEXT_LIMIT)
                        .processNotNull(counterIds, SmartCampaign.METRIKA_COUNTERS);
            case MOBILE_CONTENT:
                return new ModelChanges<>(cid, MobileContentCampaign.class)
                        .process(toCampaignStrategy(input.getBiddingStrategy()), MobileContentCampaign.STRATEGY)
                        .process(setScaleForCore(input.getDayBudget()), MobileContentCampaign.DAY_BUDGET)
                        .process(toCampaignDayBudgetShowMode(input.getDayBudgetShowMode()),
                                MobileContentCampaign.DAY_BUDGET_SHOW_MODE)
                        .process(input.getContextLimit(), MobileContentCampaign.CONTEXT_LIMIT)
                        .process(input.getEnableCpcHold(), MobileContentCampaign.ENABLE_CPC_HOLD);
            case MCBANNER:
                return new ModelChanges<>(cid, McBannerCampaign.class)
                        .process(toCampaignStrategy(input.getBiddingStrategy()), McBannerCampaign.STRATEGY)
                        .process(setScaleForCore(input.getDayBudget()), McBannerCampaign.DAY_BUDGET)
                        .process(toCampaignDayBudgetShowMode(input.getDayBudgetShowMode()),
                                McBannerCampaign.DAY_BUDGET_SHOW_MODE)
                        .process(input.getContextLimit(), McBannerCampaign.CONTEXT_LIMIT)
                        .process(input.getEnableCpcHold(), McBannerCampaign.ENABLE_CPC_HOLD)
                        .processNotNull(counterIds, McBannerCampaign.METRIKA_COUNTERS);
            default:
                throw new IllegalStateException("Unexpected value: " + input.getType());
        }
    }

}
