package ru.yandex.direct.grid.processing.service.campaign.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCampaignsWeeklyBudget;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class UpdateCampaignsWeeklyBudgetConverter {

    private UpdateCampaignsWeeklyBudgetConverter() {
    }

    public static List<? extends ModelChanges<? extends BaseCampaign>> toCoreModelChanges(
            GdUpdateCampaignsWeeklyBudget input, List<Campaign> campaigns) {
        return mapList(campaigns, campaign -> itemToModelChanges(campaign, input));
    }

    private static ModelChanges<? extends BaseCampaign> itemToModelChanges(Campaign campaign,
                                                                           GdUpdateCampaignsWeeklyBudget input) {
        return new ModelChanges<>(campaign.getId(), CampaignWithStrategy.class)
                .process(updateWeeklyBudget(campaign, input), CampaignWithStrategy.STRATEGY);
    }

    private static DbStrategy updateWeeklyBudget(Campaign campaign,
                                                 GdUpdateCampaignsWeeklyBudget input){
        DbStrategy currentStrategy = campaign.getStrategy();
        currentStrategy.getStrategyData().withSum(setScaleForCore(input.getWeeklyBudget()));

        return currentStrategy;
    }
}
