package ru.yandex.direct.grid.processing.service.campaign.converter;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdMeaningfulGoalRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMeaningfulGoals;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class UpdateMeaningfulGoalsConverter {
    private UpdateMeaningfulGoalsConverter() {
    }

    public static List<? extends ModelChanges<? extends BaseCampaign>> toCoreModelChanges(
            GdUpdateMeaningfulGoals input,
            Map<Long, List<Long>> campaignIdToCounterIds,
            @Nullable Map<Long, List<Long>> newMeaningfulGoals) {
        return StreamEx.of(input.getCampaignIds())
                .map(cid -> itemToModelChanges(cid,
                        getMeaningfulGoals(input.getMeaningfulGoals(), cid, newMeaningfulGoals),
                        campaignIdToCounterIds.get(cid)))
                .nonNull()
                .toList();
    }

    private static ModelChanges<? extends BaseCampaign> itemToModelChanges(
            Long cid,
            List<MeaningfulGoal> goals,
            @Nullable List<Long> counterIds) {
        return new ModelChanges<>(cid, CampaignWithMeaningfulGoalsWithRequiredFields.class)
                .process(goals, CampaignWithMeaningfulGoalsWithRequiredFields.MEANINGFUL_GOALS)
                .processNotNull(counterIds, CampaignWithMeaningfulGoalsWithRequiredFields.METRIKA_COUNTERS);
    }

    private static List<MeaningfulGoal> getMeaningfulGoals(List<GdMeaningfulGoalRequest> goalRequests, Long cid,
                                                           @Nullable Map<Long, List<Long>> newMeaningfulGoals) {
        var goals = mapList(goalRequests, UpdateMeaningfulGoalsConverter::gdMeaningfulGoalRequestToCore);
        if (newMeaningfulGoals == null) {
            return goals;
        } else if (newMeaningfulGoals.get(cid) == null) {
            return Collections.emptyList();
        }
        var newGoals = newMeaningfulGoals.get(cid);
        return StreamEx.of(goals)
                .filter(goal -> newGoals.contains(goal.getGoalId()))
                .toList();
    }

    private static MeaningfulGoal gdMeaningfulGoalRequestToCore(GdMeaningfulGoalRequest request) {
        return new MeaningfulGoal()
                .withGoalId(request.getGoalId())
                .withConversionValue(request.getConversionValue());
    }
}
