package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCmpBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddContentPromotionCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCpmPriceCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCpmYndxFrontpageCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddDynamicCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddInternalAutobudgetCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddInternalDistribCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddInternalFreeCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddMcBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddMobileContentCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddSmartCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddTextCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateContentPromotionCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCpmBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCpmPriceCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCpmYndxFrontpageCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateDynamicCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalAutobudgetCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalDistribCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalFreeCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMcBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMobileContentCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateSmartCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateTextCampaign;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Map.entry;

@ParametersAreNonnullByDefault
public class CampaignConverterFacade {
    public static Map<Class<? extends GdUpdateAbstractCampaign>, CampaignConverterSupport> getSupportMapForUpdate(
            CampaignConverterContext converterContext) {
        return Map.ofEntries(
                entry(GdUpdateTextCampaign.class, new TextCampaignConverterSupport(converterContext)),
                entry(GdUpdateMcBannerCampaign.class, new McBannerCampaignConverterSupport(converterContext)),
                entry(GdUpdateDynamicCampaign.class, new DynamicCampaignConverterSupport(converterContext)),
                entry(GdUpdateSmartCampaign.class, new SmartCampaignConverterSupport(converterContext)),
                entry(GdUpdateMobileContentCampaign.class, new MobileContentCampaignConverterSupport(converterContext)),
                entry(GdUpdateContentPromotionCampaign.class,
                        new ContentPromotionCampaignConverterSupport(converterContext)),
                entry(GdUpdateCpmPriceCampaign.class, new CpmPriceCampaignConverterSupport(converterContext)),
                entry(GdUpdateCpmYndxFrontpageCampaign.class,
                        new CpmYndxFrontpageCampaignConverterSupport(converterContext)),
                entry(GdUpdateCpmBannerCampaign.class, new CpmBannerCampaignConverterSupport(converterContext)),
                entry(GdUpdateInternalFreeCampaign.class, new InternalFreeCampaignConverterSupport()),
                entry(GdUpdateInternalDistribCampaign.class, new InternalDistribCampaignConverterSupport()),
                entry(GdUpdateInternalAutobudgetCampaign.class, new InternalAutobudgetCampaignConverterSupport()));
    }

    public static Map<Class<? extends GdAddAbstractCampaign>, CampaignConverterSupport> getSupportMapForAdd(
            CampaignConverterContext converterContext) {
        return Map.ofEntries(
                entry(GdAddTextCampaign.class, new TextCampaignConverterSupport(converterContext)),
                entry(GdAddMcBannerCampaign.class, new McBannerCampaignConverterSupport(converterContext)),
                entry(GdAddDynamicCampaign.class, new DynamicCampaignConverterSupport(converterContext)),
                entry(GdAddSmartCampaign.class, new SmartCampaignConverterSupport(converterContext)),
                entry(GdAddMobileContentCampaign.class, new MobileContentCampaignConverterSupport(converterContext)),
                entry(GdAddContentPromotionCampaign.class,
                        new ContentPromotionCampaignConverterSupport(converterContext)),
                entry(GdAddCpmPriceCampaign.class, new CpmPriceCampaignConverterSupport(converterContext)),
                entry(GdAddCpmYndxFrontpageCampaign.class,
                        new CpmYndxFrontpageCampaignConverterSupport(converterContext)),
                entry(GdAddCmpBannerCampaign.class, new CpmBannerCampaignConverterSupport(converterContext)),
                entry(GdAddInternalFreeCampaign.class, new InternalFreeCampaignConverterSupport()),
                entry(GdAddInternalDistribCampaign.class, new InternalDistribCampaignConverterSupport()),
                entry(GdAddInternalAutobudgetCampaign.class, new InternalAutobudgetCampaignConverterSupport()));
    }

    public static CampaignConverterSupport getSupportByUpdateType(Class<? extends GdUpdateAbstractCampaign> campaignClass,
                                                                  CampaignConverterContext converterContext) {
        var supportMap = getSupportMapForUpdate(converterContext);
        checkArgument(supportMap.containsKey(campaignClass),
                "Unsupported campaign class: " + campaignClass.getCanonicalName());
        return supportMap.get(campaignClass);
    }

    public static CampaignConverterSupport getSupportByAddType(Class<? extends GdAddAbstractCampaign> campaignClass,
                                                               CampaignConverterContext converterContext) {
        var supportMap = getSupportMapForAdd(converterContext);
        checkArgument(supportMap.containsKey(campaignClass),
                "Unsupported campaign class: " + campaignClass.getCanonicalName());
        return supportMap.get(campaignClass);
    }
}
