package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddAbstractCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateAbstractCampaign;
import ru.yandex.direct.model.ModelChanges;

@ParametersAreNonnullByDefault
public interface CampaignConverterSupport<C extends BaseCampaign, T extends GdUpdateAbstractCampaign,
        A extends GdAddAbstractCampaign> {
    C toCoreCampaign(T campaign);

    C toCoreCampaign(A campaign);

    ModelChanges<C> toModelChanges(C campaign);
}
