package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddContentPromotionCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateContentPromotionCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.model.ModelChanges;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toNullableMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class ContentPromotionCampaignConverterSupport
        implements CampaignConverterSupport<ContentPromotionCampaign, GdUpdateContentPromotionCampaign, GdAddContentPromotionCampaign> {

    private final CampaignConverterContext converterContext;

    public ContentPromotionCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public ContentPromotionCampaign toCoreCampaign(GdUpdateContentPromotionCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        return new ContentPromotionCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.CONTENT_PROMOTION)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toNullableMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withStrategyId(campaign.getStrategyId())

                // TODO(dimitrovsd): переделать на интерфейс
                .withEnableSendAccountNews(false)
                // Поля оставлять null'ами нельзя - старый интерфейс начнет падать
                .withDisabledSsp(emptyList())
                .withDisabledDomains(emptyList())
                .withRequireFiltrationByDontShowDomains(false);
    }

    @Override
    public ContentPromotionCampaign toCoreCampaign(GdAddContentPromotionCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        return new ContentPromotionCampaign()
                .withType(CampaignType.CONTENT_PROMOTION)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withStrategyId(campaign.getStrategyId())

                // TODO(dimitrovsd): переделать на интерфейс
                .withEnableSendAccountNews(false)
                // Поля оставлять null'ами нельзя - старый интерфейс начнет падать
                .withDisabledSsp(emptyList())
                .withDisabledDomains(emptyList())
                .withRequireFiltrationByDontShowDomains(false);
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<ContentPromotionCampaign> toModelChanges(ContentPromotionCampaign campaign) {
        ModelChanges<ContentPromotionCampaign> changes = new ModelChanges<>(campaign.getId(), ContentPromotionCampaign.class)
                .process(campaign.getType(), ContentPromotionCampaign.TYPE)
                .process(campaign.getName(), ContentPromotionCampaign.NAME)
                .process(campaign.getStartDate(), ContentPromotionCampaign.START_DATE)
                .process(campaign.getEndDate(), ContentPromotionCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), ContentPromotionCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledIps(), ContentPromotionCampaign.DISABLED_IPS)
                .process(campaign.getMinusKeywords(), ContentPromotionCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), ContentPromotionCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), ContentPromotionCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), ContentPromotionCampaign.EMAIL)
                .process(campaign.getWarningBalance(), ContentPromotionCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(), ContentPromotionCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getHasExtendedGeoTargeting(), ContentPromotionCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), ContentPromotionCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), ContentPromotionCampaign.USE_REGULAR_REGION)
                .process(campaign.getBidModifiers(), ContentPromotionCampaign.BID_MODIFIERS)
                .process(campaign.getDayBudget(), ContentPromotionCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), ContentPromotionCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getStrategy(), ContentPromotionCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), ContentPromotionCampaign.TIME_TARGET)
                .process(campaign.getAttributionModel(), ContentPromotionCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeZoneId(), ContentPromotionCampaign.TIME_ZONE_ID)
                .process(campaign.getDisabledSsp(), ContentPromotionCampaign.DISABLED_SSP)
                .process(campaign.getDisabledDomains(), ContentPromotionCampaign.DISABLED_DOMAINS)
                .process(false, ContentPromotionCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
                .process(campaign.getHref(), ContentPromotionCampaign.HREF)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        ContentPromotionCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        ContentPromotionCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getBrandSafetyCategories(), ContentPromotionCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getStrategyId(), ContentPromotionCampaign.STRATEGY_ID);

        if (converterContext.getShouldProcessProperties().contains(ContentPromotionCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), ContentPromotionCampaign.CONTENT_LANGUAGE);
        }

        return changes;
    }
}
