package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignsAutobudget;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.EshowsRate;
import ru.yandex.direct.core.entity.campaign.model.EshowsSettings;
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType;
import ru.yandex.direct.core.entity.campaign.model.ImpressionStandardTime;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.grid.model.campaign.GdEshowsRate;
import ru.yandex.direct.grid.model.campaign.GdEshowsSettings;
import ru.yandex.direct.grid.model.campaign.GdEshowsVideoType;
import ru.yandex.direct.grid.model.campaign.GdImpressionStandardTime;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCmpBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdShowsFrequencyLimitRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCpmBannerCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.core.entity.campaign.converter.CampaignConverter.setFieldIfNull;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getImpressionRateIntervalDays;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeasurers;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@ParametersAreNonnullByDefault
public class CpmBannerCampaignConverterSupport implements CampaignConverterSupport<CpmBannerCampaign,
        GdUpdateCpmBannerCampaign,
        GdAddCmpBannerCampaign> {
    private final CampaignConverterContext converterContext;

    CpmBannerCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public CpmBannerCampaign toCoreCampaign(GdUpdateCpmBannerCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        DbStrategy strategy = ifNotNull(campaign.getBiddingStategy(), CommonCampaignConverter::toCampaignStrategy);
        if (strategy != null) {
            strategy.setStrategy(CampOptionsStrategy.DIFFERENT_PLACES);
        }

        CpmBannerCampaign cpmBannerCampaign = new CpmBannerCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.CPM_BANNER)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withDisabledVideoPlacements(campaign.getDisabledVideoAdsPlaces())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withDisallowedPageIds(campaign.getDisallowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                        campaign.getAllowedDomains()))
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withBrandSurveyId(campaign.getBrandSurveyId())
                .withBrandSurveyName(campaign.getBrandSurveyName())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                //todo ssdmitriev: мб приедтся убрать
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withStrategy(strategy)
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withMeasurers(toMeasurers(campaign.getMeasurers()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withImpressionRateCount(ifNotNull(campaign.getShowsFrequencyLimit(),
                        GdShowsFrequencyLimitRequest::getLimit))
                .withImpressionRateIntervalDays(getImpressionRateIntervalDays(campaign.getShowsFrequencyLimit()))
                .withIsAllowedOnAdultContent(campaign.getIsAllowedOnAdultContent())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withEshowsSettings(toEshowsSettings(campaign.getEshowsSettings()))
                .withStrategyId(campaign.getStrategyId());

        setFieldIfNull(cpmBannerCampaign, CpmBannerCampaign.STRATEGY, createDefaultStrategyData());

        return cpmBannerCampaign;
    }

    @Override
    public CpmBannerCampaign toCoreCampaign(GdAddCmpBannerCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        DbStrategy strategy = ifNotNull(campaign.getBiddingStategy(), CommonCampaignConverter::toCampaignStrategy);
        strategy.setStrategy(CampOptionsStrategy.DIFFERENT_PLACES);

        return new CpmBannerCampaign()
                .withType(CampaignType.CPM_BANNER)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withDisabledVideoPlacements(campaign.getDisabledVideoAdsPlaces())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withDisallowedPageIds(campaign.getDisallowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                        campaign.getAllowedDomains()))
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withBrandSurveyId(campaign.getBrandSurveyId())
                .withBrandSurveyName(campaign.getBrandSurveyName())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withStrategy(strategy)
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withMeasurers(toMeasurers(campaign.getMeasurers()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withImpressionRateCount(ifNotNull(campaign.getShowsFrequencyLimit(),
                        GdShowsFrequencyLimitRequest::getLimit))
                .withImpressionRateIntervalDays(getImpressionRateIntervalDays(campaign.getShowsFrequencyLimit()))
                .withImpressionStandardTime(toImpressionStandardTime(campaign.getImpressionStandardTime()))
                .withEshowsSettings(toEshowsSettings(campaign.getEshowsSettings()))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsAllowedOnAdultContent(campaign.getIsAllowedOnAdultContent())
                .withStrategyId(campaign.getStrategyId());
    }

    public static ImpressionStandardTime toImpressionStandardTime(GdImpressionStandardTime gdImpressionStandardTime) {
        return ifNotNull(gdImpressionStandardTime, type -> ImpressionStandardTime.valueOf(type.name().toUpperCase()));
    }

    private static EshowsSettings toEshowsSettings(@Nullable GdEshowsSettings eshowsSettings) {
        if (eshowsSettings == null) {
            return new EshowsSettings();
        }

        return new EshowsSettings()
                .withBannerRate(toEshowsRate(eshowsSettings.getBannerRate()))
                .withVideoRate(toEshowsRate(eshowsSettings.getVideoRate()))
                .withVideoType(toEshowsVideoType(eshowsSettings.getVideoType()));
    }

    private static EshowsRate toEshowsRate(GdEshowsRate gdEshowsRate) {
        return ifNotNull(gdEshowsRate, type -> EshowsRate.valueOf(type.name().toUpperCase()));
    }

    private static EshowsVideoType toEshowsVideoType(GdEshowsVideoType gdEshowsVideoType) {
        return ifNotNull(gdEshowsVideoType, type -> EshowsVideoType.valueOf(type.name().toUpperCase()));
    }

    /**
     * на время интеграции с фронтом, после готовности фронта поле стратегий становится обязательным
     */
    public static DbStrategy createDefaultStrategyData() {
        String cpmDefault = "cpm_default";
        StrategyData strategyData = new StrategyData()
                .withVersion(1L)
                .withName(cpmDefault);
        return (DbStrategy) new DbStrategy()
                .withStrategy(CampOptionsStrategy.DIFFERENT_PLACES)
                .withAutobudget(CampaignsAutobudget.YES)
                .withStrategyName(StrategyName.CPM_DEFAULT)
                .withStrategyData(strategyData);
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<CpmBannerCampaign> toModelChanges(CpmBannerCampaign campaign) {
        ModelChanges<CpmBannerCampaign> changes = new ModelChanges<>(campaign.getId(), CpmBannerCampaign.class)
                .process(campaign.getType(), CpmBannerCampaign.TYPE)
                .process(campaign.getName(), CpmBannerCampaign.NAME)
                .process(campaign.getStartDate(), CpmBannerCampaign.START_DATE)
                .process(campaign.getEndDate(), CpmBannerCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), CpmBannerCampaign.METRIKA_COUNTERS)
                .process(campaign.getMeaningfulGoals(), CpmBannerCampaign.MEANINGFUL_GOALS)
                .process(campaign.getDisabledDomains(), CpmBannerCampaign.DISABLED_DOMAINS)
                .process(campaign.getDisabledSsp(), CpmBannerCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), CpmBannerCampaign.DISABLED_IPS)
                .process(campaign.getDisabledVideoPlacements(), CpmBannerCampaign.DISABLED_VIDEO_PLACEMENTS)
                .process(campaign.getHasAddMetrikaTagToUrl(), CpmBannerCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasAddOpenstatTagToUrl(), CpmBannerCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getSmsTime(), CpmBannerCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), CpmBannerCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), CpmBannerCampaign.EMAIL)
                .process(campaign.getWarningBalance(), CpmBannerCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(),
                        CpmBannerCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), CpmBannerCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), CpmBannerCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getHasSiteMonitoring(), CpmBannerCampaign.HAS_SITE_MONITORING)
                .process(campaign.getHasExtendedGeoTargeting(), CpmBannerCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), CpmBannerCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), CpmBannerCampaign.USE_REGULAR_REGION)
                .process(campaign.getBidModifiers(), CpmBannerCampaign.BID_MODIFIERS)
                .process(campaign.getTimeTarget(), CpmBannerCampaign.TIME_TARGET)
                .process(campaign.getAttributionModel(), CpmBannerCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeZoneId(), CpmBannerCampaign.TIME_ZONE_ID)
                .process(campaign.getImpressionRateCount(), CpmBannerCampaign.IMPRESSION_RATE_COUNT)
                .process(campaign.getImpressionRateIntervalDays(),
                        CpmBannerCampaign.IMPRESSION_RATE_INTERVAL_DAYS)
                .process(campaign.getStrategy(), CpmBannerCampaign.STRATEGY)
                .process(campaign.getDayBudget(), CpmBannerCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), CpmBannerCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getHref(), CpmBannerCampaign.HREF)
                .process(campaign.getEshowsSettings(), CpmBannerCampaign.ESHOWS_SETTINGS)
                .processNotNull(campaign.getBrandSafetyCategories(), CpmBannerCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getMeasurers(), CpmBannerCampaign.MEASURERS)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        CpmBannerCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        CpmBannerCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsAllowedOnAdultContent(), CpmBannerCampaign.IS_ALLOWED_ON_ADULT_CONTENT)
                .processNotNull(campaign.getStrategyId(), CpmBannerCampaign.STRATEGY_ID);

        if (campaign.getRequireFiltrationByDontShowDomains() != null) {
            changes.process(campaign.getRequireFiltrationByDontShowDomains(),
                    CpmBannerCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        }

        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), CpmBannerCampaign.CONTENT_LANGUAGE);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.ALLOWED_PAGE_IDS)) {
            changes.process(campaign.getAllowedPageIds(), CpmBannerCampaign.ALLOWED_PAGE_IDS);
            changes.process(campaign.getAllowedDomains(), TextCampaign.ALLOWED_DOMAINS);
            changes.process(campaign.getAllowedSsp(), TextCampaign.ALLOWED_SSP);
        }

        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.DISALLOWED_PAGE_IDS)) {
            changes.process(campaign.getDisallowedPageIds(), CpmBannerCampaign.DISALLOWED_PAGE_IDS);
        }

        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.SECTION_IDS)) {
            changes.process(campaign.getSectionIds(), CpmBannerCampaign.SECTION_IDS);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.AB_SEGMENT_GOAL_IDS)) {
            changes.process(campaign.getAbSegmentGoalIds(), CpmBannerCampaign.AB_SEGMENT_GOAL_IDS);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.BRAND_SURVEY_ID)) {
            changes.process(campaign.getBrandSurveyId(), CpmBannerCampaign.BRAND_SURVEY_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmBannerCampaign.BRAND_SURVEY_NAME)) {
            changes.process(campaign.getBrandSurveyName(), CpmBannerCampaign.BRAND_SURVEY_NAME);
        }

        return changes;
    }
}
