package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmYndxFrontpageCampaign;
import ru.yandex.direct.core.entity.campaign.model.DayBudgetShowMode;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddCpmYndxFrontpageCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateCpmYndxFrontpageCampaign;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.utils.FunctionalUtils;

import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeasurers;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.type.CpmBannerCampaignConverterSupport.toImpressionStandardTime;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class CpmYndxFrontpageCampaignConverterSupport implements CampaignConverterSupport<CpmYndxFrontpageCampaign,
        GdUpdateCpmYndxFrontpageCampaign,
        GdAddCpmYndxFrontpageCampaign> {

    private final CampaignConverterContext converterContext;

    CpmYndxFrontpageCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public CpmYndxFrontpageCampaign toCoreCampaign(GdAddCpmYndxFrontpageCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        return new CpmYndxFrontpageCampaign()
                .withType(CampaignType.CPM_YNDX_FRONTPAGE)
                .withName(campaign.getName())
                .withAllowedFrontpageType(FunctionalUtils.mapSet(campaign.getAllowedFrontpageType(), CommonCampaignConverter::toFrontpageCampaignShowType))
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledIps(campaign.getDisabledIps())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withStrategy(CommonCampaignConverter.toCampaignStrategy(campaign.getStrategy()))
                .withDayBudget(setScaleForCore(nvl(campaign.getDayBudget(), BigDecimal.ZERO)))
                .withDayBudgetShowMode(nvl(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()),
                        DayBudgetShowMode.DEFAULT_))
                .withBrandSurveyId(campaign.getBrandSurveyId())
                .withBrandSurveyName(campaign.getBrandSurveyName())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withMeasurers(toMeasurers(campaign.getMeasurers()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withImpressionStandardTime(toImpressionStandardTime(campaign.getImpressionStandardTime()))
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    public CpmYndxFrontpageCampaign toCoreCampaign(GdUpdateCpmYndxFrontpageCampaign campaign) {
        // minusKeywords есть в GdUpdateCpmPriceCampaign, пришли из базового GdUpdateAbstractCampaign
        // но в прайсовых нам minusKeywords не нужны, игнорируем их здесь
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        return new CpmYndxFrontpageCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.CPM_YNDX_FRONTPAGE)
                .withAllowedFrontpageType(FunctionalUtils.mapSet(campaign.getAllowedFrontpageType(), CommonCampaignConverter::toFrontpageCampaignShowType))
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledIps(campaign.getDisabledIps())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withStrategy(CommonCampaignConverter.toCampaignStrategy(campaign.getStrategy()))
                .withDayBudget(setScaleForCore(nvl(campaign.getDayBudget(), BigDecimal.ZERO)))
                .withDayBudgetShowMode(nvl(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()),
                        DayBudgetShowMode.DEFAULT_))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withBrandSurveyId(campaign.getBrandSurveyId())
                .withBrandSurveyName(campaign.getBrandSurveyName())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withMeasurers(toMeasurers(campaign.getMeasurers()))
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<CpmYndxFrontpageCampaign> toModelChanges(CpmYndxFrontpageCampaign campaign) {
        ModelChanges<CpmYndxFrontpageCampaign> changes = new ModelChanges<>(campaign.getId(), CpmYndxFrontpageCampaign.class)
                .process(campaign.getType(), CpmYndxFrontpageCampaign.TYPE)
                .process(campaign.getName(), CpmYndxFrontpageCampaign.NAME)
                .process(campaign.getAllowedFrontpageType(), CpmYndxFrontpageCampaign.ALLOWED_FRONTPAGE_TYPE)
                .process(campaign.getStartDate(), CpmYndxFrontpageCampaign.START_DATE)
                .process(campaign.getEndDate(), CpmYndxFrontpageCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), CpmYndxFrontpageCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledIps(), CpmYndxFrontpageCampaign.DISABLED_IPS)
                .process(campaign.getHasAddMetrikaTagToUrl(), CpmYndxFrontpageCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasAddOpenstatTagToUrl(), CpmYndxFrontpageCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getHasSiteMonitoring(), CpmYndxFrontpageCampaign.HAS_SITE_MONITORING)
                .process(campaign.getSmsTime(), CpmYndxFrontpageCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), CpmYndxFrontpageCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), CpmYndxFrontpageCampaign.EMAIL)
                .process(campaign.getWarningBalance(), CpmYndxFrontpageCampaign.WARNING_BALANCE)
                .process(campaign.getEnableSendAccountNews(), CpmYndxFrontpageCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnablePausedByDayBudgetEvent(), CpmYndxFrontpageCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableOfflineStatNotice(), CpmYndxFrontpageCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getAttributionModel(), CpmYndxFrontpageCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeTarget(), CpmYndxFrontpageCampaign.TIME_TARGET)
                .process(campaign.getTimeZoneId(), CpmYndxFrontpageCampaign.TIME_ZONE_ID)
                .process(campaign.getStrategy(), CpmYndxFrontpageCampaign.STRATEGY)
                .process(campaign.getDayBudget(), CpmYndxFrontpageCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), CpmYndxFrontpageCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getHref(), CpmYndxFrontpageCampaign.HREF)
                .processNotNull(campaign.getBrandSafetyCategories(), CpmYndxFrontpageCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        CpmYndxFrontpageCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        CpmYndxFrontpageCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getMeasurers(), CpmBannerCampaign.MEASURERS)
                .processNotNull(campaign.getStrategyId(), CpmBannerCampaign.STRATEGY_ID);

        if (converterContext.getShouldProcessProperties().contains(CpmYndxFrontpageCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), CpmYndxFrontpageCampaign.CONTENT_LANGUAGE);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmYndxFrontpageCampaign.BRAND_SURVEY_ID)) {
            changes.process(campaign.getBrandSurveyId(), CpmYndxFrontpageCampaign.BRAND_SURVEY_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(CpmYndxFrontpageCampaign.BRAND_SURVEY_NAME)) {
            changes.process(campaign.getBrandSurveyName(), CpmYndxFrontpageCampaign.BRAND_SURVEY_NAME);
        }

        return changes;
    }

}
