package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddDynamicCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateDynamicCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.model.ModelChanges;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_TURBO_SMARTS;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.filterSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCoreVcard;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toPlacementTypes;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class DynamicCampaignConverterSupport implements CampaignConverterSupport<DynamicCampaign,
        GdUpdateDynamicCampaign,
        GdAddDynamicCampaign> {
    private final CampaignConverterContext converterContext;

    DynamicCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public DynamicCampaign toCoreCampaign(GdUpdateDynamicCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = new ArrayList<>();
        if (!isEmpty(campaign.getDisabledPlaces())) {
            campaign.getDisabledPlaces().forEach(place -> knownSsp.forEach(ssp -> {
                if (place.equalsIgnoreCase(ssp)) {
                    disabledSsp.add(ssp);
                }
            }));
        }
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new DynamicCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.DYNAMIC)
                .withName(campaign.getName())
                .withContactInfo(toCoreVcard(campaign.getVcard()))
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withPlacementTypes(toPlacementTypes(campaign.getPlacementTypes()))
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasTitleSubstitution(campaign.getHasTitleSubstitute())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(filterSsp(knownSsp, campaign.getAllowedDomains()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withEnableCompanyInfo(campaign.getEnableCompanyInfo())
                .withDefaultPermalinkId(campaign.getDefaultPermalinkId())
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withPromoExtensionId(campaign.getPromoExtensionId())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withStrategyId(campaign.getStrategyId())
                // не используется, заполняем дефолтным значением
                .withHasTurboSmarts(DEFAULT_HAS_TURBO_SMARTS);
    }

    @Override
    public DynamicCampaign toCoreCampaign(GdAddDynamicCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new DynamicCampaign()
                .withType(CampaignType.DYNAMIC)
                .withName(campaign.getName())
                .withContactInfo(toCoreVcard(campaign.getVcard()))
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withPlacementTypes(toPlacementTypes(campaign.getPlacementTypes()))
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasTitleSubstitution(campaign.getHasTitleSubstitute())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withEnableCompanyInfo(campaign.getEnableCompanyInfo())
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                        campaign.getAllowedDomains()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withDefaultPermalinkId(campaign.getDefaultPermalinkId())
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withPromoExtensionId(campaign.getPromoExtensionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withStrategyId(campaign.getStrategyId())
                // не используется, заполняем дефолтным значением
                .withHasTurboSmarts(DEFAULT_HAS_TURBO_SMARTS);
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<DynamicCampaign> toModelChanges(DynamicCampaign campaign) {
        ModelChanges<DynamicCampaign> changes = new ModelChanges<>(campaign.getId(), DynamicCampaign.class)
                .process(campaign.getType(), DynamicCampaign.TYPE)
                .process(campaign.getName(), DynamicCampaign.NAME)
                .process(campaign.getContactInfo(), DynamicCampaign.CONTACT_INFO)
                .process(campaign.getStartDate(), DynamicCampaign.START_DATE)
                .process(campaign.getEndDate(), DynamicCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), DynamicCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledDomains(), DynamicCampaign.DISABLED_DOMAINS)
                .process(campaign.getDisabledSsp(), DynamicCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), DynamicCampaign.DISABLED_IPS)
                .process(campaign.getPlacementTypes(), DynamicCampaign.PLACEMENT_TYPES)
                .process(campaign.getHasTitleSubstitution(), DynamicCampaign.HAS_TITLE_SUBSTITUTION)
                .process(campaign.getIsAloneTrafaretAllowed(), DynamicCampaign.IS_ALONE_TRAFARET_ALLOWED)
                .process(campaign.getHasAddMetrikaTagToUrl(), DynamicCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasAddOpenstatTagToUrl(), DynamicCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getMinusKeywords(), DynamicCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), DynamicCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), DynamicCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), DynamicCampaign.EMAIL)
                .process(campaign.getWarningBalance(), DynamicCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(), DynamicCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), DynamicCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), DynamicCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), DynamicCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(), DynamicCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getHasSiteMonitoring(), DynamicCampaign.HAS_SITE_MONITORING)
                .process(campaign.getHasExtendedGeoTargeting(), DynamicCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), DynamicCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), DynamicCampaign.USE_REGULAR_REGION)
                .process(campaign.getMeaningfulGoals(), DynamicCampaign.MEANINGFUL_GOALS)
                .process(campaign.getBidModifiers(), DynamicCampaign.BID_MODIFIERS)
                .process(campaign.getEnableCpcHold(), DynamicCampaign.ENABLE_CPC_HOLD)
                .process(campaign.getHasTurboApp(), DynamicCampaign.HAS_TURBO_APP)
                .process(campaign.getAbSegmentRetargetingConditionId(),
                        DynamicCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        DynamicCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), DynamicCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), DynamicCampaign.AB_SEGMENT_GOAL_IDS)
                .process(campaign.getDayBudget(), DynamicCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), DynamicCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getEnableCompanyInfo(), DynamicCampaign.ENABLE_COMPANY_INFO)
                .process(campaign.getDefaultPermalinkId(), DynamicCampaign.DEFAULT_PERMALINK_ID)
                .process(campaign.getStrategy(), DynamicCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), DynamicCampaign.TIME_TARGET)
                .process(campaign.getAttributionModel(), DynamicCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeZoneId(), DynamicCampaign.TIME_ZONE_ID)
                .process(campaign.getPromoExtensionId(), DynamicCampaign.PROMO_EXTENSION_ID)
                .process(campaign.getHref(), DynamicCampaign.HREF)
                .process(campaign.getBannerHrefParams(), DynamicCampaign.BANNER_HREF_PARAMS)
                .process(campaign.getHasTurboSmarts(), DynamicCampaign.HAS_TURBO_SMARTS)
                .processNotNull(campaign.getIsSimplifiedStrategyViewEnabled(),
                        DynamicCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                .processNotNull(campaign.getBrandSafetyCategories(), DynamicCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getIsOrderPhraseLengthPrecedenceEnabled(),
                        DynamicCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                .processNotNull(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled(),
                        DynamicCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        DynamicCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        DynamicCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsS2sTrackingEnabled(), DynamicCampaign.IS_S2S_TRACKING_ENABLED)
                .processNotNull(campaign.getStrategyId(), DynamicCampaign.STRATEGY_ID);

        if (campaign.getRequireFiltrationByDontShowDomains() != null) {
            changes.process(campaign.getRequireFiltrationByDontShowDomains(),
                    DynamicCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        }

        if (converterContext.getShouldProcessProperties().contains(DynamicCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentRetargetingConditionId(),
                    DynamicCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties()
                .contains(DynamicCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                    DynamicCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(DynamicCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), DynamicCampaign.CONTENT_LANGUAGE);
        }
        if (converterContext.getShouldProcessProperties().contains(DynamicCampaign.ALLOWED_PAGE_IDS)) {
            changes.process(campaign.getAllowedPageIds(), DynamicCampaign.ALLOWED_PAGE_IDS);
            changes.process(campaign.getAllowedDomains(), DynamicCampaign.ALLOWED_DOMAINS);
            changes.process(campaign.getAllowedSsp(), DynamicCampaign.ALLOWED_SSP);
        }

        return changes;
    }
}
