package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddInternalAutobudgetCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalAutobudgetCampaign;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toRfCloseByClickType;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.grid.processing.util.RfConverter.toCoreRfPeriod;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@ParametersAreNonnullByDefault
public class InternalAutobudgetCampaignConverterSupport implements CampaignConverterSupport<
        InternalAutobudgetCampaign, GdUpdateInternalAutobudgetCampaign, GdAddInternalAutobudgetCampaign> {
    private static final CampaignType CAMPAIGN_TYPE = CampaignType.INTERNAL_AUTOBUDGET;

    public InternalAutobudgetCampaignConverterSupport() {
    }

    @Override
    public InternalAutobudgetCampaign toCoreCampaign(GdUpdateInternalAutobudgetCampaign campaign) {
        var smsSettings = campaign.getNotification().getSmsSettings();
        var emailSettings = campaign.getNotification().getEmailSettings();

        InternalAutobudgetCampaign resultingCampaign = new InternalAutobudgetCampaign()
                .withId(campaign.getId())
                .withType(CAMPAIGN_TYPE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledIps(campaign.getDisabledIps())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))

                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withPageId(campaign.getPageId())
                .withRfCloseByClick(toRfCloseByClickType(campaign.getRfCloseByClick()))

                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withStrategyId(campaign.getStrategyId());

        var impressionFrequencyControl = campaign.getImpressionFrequencyControl();
        if (impressionFrequencyControl != null) {
            resultingCampaign
                    .withImpressionRateIntervalDays(impressionFrequencyControl.getDays())
                    .withImpressionRateCount(impressionFrequencyControl.getImpressions())
                    .withMaxClicksCount(impressionFrequencyControl.getMaxClicksCount())
                    .withMaxClicksPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxClicksPeriod()))
                    .withMaxStopsCount(impressionFrequencyControl.getMaxStopsCount())
                    .withMaxStopsPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxStopsPeriod()));
        }

        return resultingCampaign;
    }

    @Override
    public InternalAutobudgetCampaign toCoreCampaign(GdAddInternalAutobudgetCampaign campaign) {
        var smsSettings = campaign.getNotification().getSmsSettings();
        var emailSettings = campaign.getNotification().getEmailSettings();

        InternalAutobudgetCampaign resultingCampaign = new InternalAutobudgetCampaign()
                .withType(CAMPAIGN_TYPE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledIps(campaign.getDisabledIps())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))

                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withIsMobile(campaign.getIsMobile())
                .withPlaceId(campaign.getPlaceId())
                .withPageId(campaign.getPageId())
                .withRfCloseByClick(toRfCloseByClickType(campaign.getRfCloseByClick()))

                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withStrategyId(campaign.getStrategyId());


        var impressionFrequencyControl = campaign.getImpressionFrequencyControl();
        if (impressionFrequencyControl != null) {
            resultingCampaign
                    .withImpressionRateIntervalDays(impressionFrequencyControl.getDays())
                    .withImpressionRateCount(impressionFrequencyControl.getImpressions())
                    .withMaxClicksCount(impressionFrequencyControl.getMaxClicksCount())
                    .withMaxClicksPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxClicksPeriod()))
                    .withMaxStopsCount(impressionFrequencyControl.getMaxStopsCount())
                    .withMaxStopsPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxStopsPeriod()));
        }

        return resultingCampaign;
    }

    @Override
    public ModelChanges<InternalAutobudgetCampaign> toModelChanges(InternalAutobudgetCampaign campaign) {
        return new ModelChanges<>(campaign.getId(), InternalAutobudgetCampaign.class)
                .process(campaign.getType(), InternalAutobudgetCampaign.TYPE)
                .process(campaign.getName(), InternalAutobudgetCampaign.NAME)
                .process(campaign.getStartDate(), InternalAutobudgetCampaign.START_DATE)
                .process(campaign.getEndDate(), InternalAutobudgetCampaign.END_DATE)
                .process(campaign.getDisabledIps(), InternalAutobudgetCampaign.DISABLED_IPS)
                .process(campaign.getSmsTime(), InternalAutobudgetCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), InternalAutobudgetCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), InternalAutobudgetCampaign.EMAIL)
                .process(campaign.getWarningBalance(), InternalAutobudgetCampaign.WARNING_BALANCE)
                .process(campaign.getEnableSendAccountNews(), InternalAutobudgetCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnablePausedByDayBudgetEvent(),
                        InternalAutobudgetCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableOfflineStatNotice(), InternalAutobudgetCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), InternalAutobudgetCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(),
                        InternalAutobudgetCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getTimeTarget(), InternalAutobudgetCampaign.TIME_TARGET)
                .process(campaign.getTimeZoneId(), InternalAutobudgetCampaign.TIME_ZONE_ID)
                .process(campaign.getStrategy(), InternalAutobudgetCampaign.STRATEGY)
                .process(campaign.getMetrikaCounters(), InternalAutobudgetCampaign.METRIKA_COUNTERS)
                .process(campaign.getMeaningfulGoals(), InternalAutobudgetCampaign.MEANINGFUL_GOALS)
                .process(campaign.getAttributionModel(), InternalAutobudgetCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getPageId(), InternalAutobudgetCampaign.PAGE_ID)
                .process(campaign.getImpressionRateIntervalDays(),
                        InternalAutobudgetCampaign.IMPRESSION_RATE_INTERVAL_DAYS)
                .process(campaign.getImpressionRateCount(), InternalAutobudgetCampaign.IMPRESSION_RATE_COUNT)
                .process(campaign.getRfCloseByClick(), InternalAutobudgetCampaign.RF_CLOSE_BY_CLICK)
                .process(campaign.getMaxClicksCount(), InternalAutobudgetCampaign.MAX_CLICKS_COUNT)
                .process(campaign.getMaxClicksPeriod(), InternalAutobudgetCampaign.MAX_CLICKS_PERIOD)
                .process(campaign.getMaxStopsCount(), InternalAutobudgetCampaign.MAX_STOPS_COUNT)
                .process(campaign.getMaxStopsPeriod(), InternalAutobudgetCampaign.MAX_STOPS_PERIOD)

                .process(campaign.getAbSegmentRetargetingConditionId(),
                        InternalAutobudgetCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        InternalAutobudgetCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), InternalAutobudgetCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), InternalAutobudgetCampaign.AB_SEGMENT_GOAL_IDS)
                .processNotNull(campaign.getStrategyId(), InternalAutobudgetCampaign.STRATEGY_ID);
    }

}
