package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.InternalFreeCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddInternalFreeCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateInternalFreeCampaign;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toInternalCampaignRestrictionType;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toRfCloseByClickType;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.grid.processing.util.RfConverter.toCoreRfPeriod;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@ParametersAreNonnullByDefault
public class InternalFreeCampaignConverterSupport implements CampaignConverterSupport<
        InternalFreeCampaign, GdUpdateInternalFreeCampaign, GdAddInternalFreeCampaign> {

    private static final CampaignType CAMPAIGN_TYPE = CampaignType.INTERNAL_FREE;

    public InternalFreeCampaignConverterSupport() {
    }

    @Override
    public InternalFreeCampaign toCoreCampaign(GdUpdateInternalFreeCampaign campaign) {
        var smsSettings = campaign.getNotification().getSmsSettings();
        var emailSettings = campaign.getNotification().getEmailSettings();

        var resultingCampaign = new InternalFreeCampaign()
                .withId(campaign.getId())
                .withType(CAMPAIGN_TYPE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledIps(campaign.getDisabledIps())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))

                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withRestrictionValue(campaign.getRestrictionValue())
                .withRestrictionType(toInternalCampaignRestrictionType(campaign.getRestrictionType()))
                .withPageId(campaign.getPageId())
                .withRfCloseByClick(toRfCloseByClickType(campaign.getRfCloseByClick()))

                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds());

        var impressionFrequencyControl = campaign.getImpressionFrequencyControl();
        if (impressionFrequencyControl != null) {
            resultingCampaign
                    .withImpressionRateIntervalDays(impressionFrequencyControl.getDays())
                    .withImpressionRateCount(impressionFrequencyControl.getImpressions())
                    .withMaxClicksCount(impressionFrequencyControl.getMaxClicksCount())
                    .withMaxClicksPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxClicksPeriod()))
                    .withMaxStopsCount(impressionFrequencyControl.getMaxStopsCount())
                    .withMaxStopsPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxStopsPeriod()));
        }

        return resultingCampaign;
    }

    @Override
    public InternalFreeCampaign toCoreCampaign(GdAddInternalFreeCampaign campaign) {
        var smsSettings = campaign.getNotification().getSmsSettings();
        var emailSettings = campaign.getNotification().getEmailSettings();

        var resultingCampaign = new InternalFreeCampaign()
                .withType(CAMPAIGN_TYPE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledIps(campaign.getDisabledIps())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))

                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withRestrictionValue(campaign.getRestrictionValue())
                .withRestrictionType(toInternalCampaignRestrictionType(campaign.getRestrictionType()))
                .withIsMobile(campaign.getIsMobile())
                .withPlaceId(campaign.getPlaceId())
                .withPageId(campaign.getPageId())
                .withRfCloseByClick(toRfCloseByClickType(campaign.getRfCloseByClick()))

                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds());

        var impressionFrequencyControl = campaign.getImpressionFrequencyControl();
        if (impressionFrequencyControl != null) {
            resultingCampaign
                    .withImpressionRateIntervalDays(impressionFrequencyControl.getDays())
                    .withImpressionRateCount(impressionFrequencyControl.getImpressions())
                    .withMaxClicksCount(impressionFrequencyControl.getMaxClicksCount())
                    .withMaxClicksPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxClicksPeriod()))
                    .withMaxStopsCount(impressionFrequencyControl.getMaxStopsCount())
                    .withMaxStopsPeriod(toCoreRfPeriod(impressionFrequencyControl.getMaxStopsPeriod()));
        }

        return resultingCampaign;
    }

    @Override
    public ModelChanges<InternalFreeCampaign> toModelChanges(InternalFreeCampaign campaign) {
        return new ModelChanges<>(campaign.getId(), InternalFreeCampaign.class)
                .process(campaign.getType(), InternalFreeCampaign.TYPE)
                .process(campaign.getName(), InternalFreeCampaign.NAME)
                .process(campaign.getStartDate(), InternalFreeCampaign.START_DATE)
                .process(campaign.getEndDate(), InternalFreeCampaign.END_DATE)
                .process(campaign.getDisabledIps(), InternalFreeCampaign.DISABLED_IPS)
                .process(campaign.getSmsTime(), InternalFreeCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), InternalFreeCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), InternalFreeCampaign.EMAIL)
                .process(campaign.getWarningBalance(), InternalFreeCampaign.WARNING_BALANCE)
                .process(campaign.getEnableSendAccountNews(), InternalFreeCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnablePausedByDayBudgetEvent(),
                        InternalFreeCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableOfflineStatNotice(), InternalFreeCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), InternalFreeCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(), InternalFreeCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getTimeTarget(), InternalFreeCampaign.TIME_TARGET)
                .process(campaign.getTimeZoneId(), InternalFreeCampaign.TIME_ZONE_ID)

                .process(campaign.getMetrikaCounters(), InternalFreeCampaign.METRIKA_COUNTERS)
                .process(campaign.getMeaningfulGoals(), InternalFreeCampaign.MEANINGFUL_GOALS)
                .process(campaign.getAttributionModel(), InternalFreeCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getRestrictionValue(), InternalFreeCampaign.RESTRICTION_VALUE)
                .process(campaign.getRestrictionType(), InternalFreeCampaign.RESTRICTION_TYPE)
                .process(campaign.getPageId(), InternalFreeCampaign.PAGE_ID)
                .process(campaign.getImpressionRateIntervalDays(), InternalFreeCampaign.IMPRESSION_RATE_INTERVAL_DAYS)
                .process(campaign.getImpressionRateCount(), InternalFreeCampaign.IMPRESSION_RATE_COUNT)
                .process(campaign.getRfCloseByClick(), InternalFreeCampaign.RF_CLOSE_BY_CLICK)
                .process(campaign.getMaxClicksCount(), InternalFreeCampaign.MAX_CLICKS_COUNT)
                .process(campaign.getMaxClicksPeriod(), InternalFreeCampaign.MAX_CLICKS_PERIOD)
                .process(campaign.getMaxStopsCount(), InternalFreeCampaign.MAX_STOPS_COUNT)
                .process(campaign.getMaxStopsPeriod(), InternalFreeCampaign.MAX_STOPS_PERIOD)

                .process(campaign.getAbSegmentRetargetingConditionId(),
                        InternalFreeCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        InternalFreeCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), InternalFreeCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), InternalFreeCampaign.AB_SEGMENT_GOAL_IDS);
    }

}
