package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.McBannerCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddMcBannerCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMcBannerCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.model.ModelChanges;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toNullableMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class McBannerCampaignConverterSupport implements CampaignConverterSupport<McBannerCampaign,
        GdUpdateMcBannerCampaign,
        GdAddMcBannerCampaign> {
    private final CampaignConverterContext converterContext;

    McBannerCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public McBannerCampaign toCoreCampaign(GdUpdateMcBannerCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = new ArrayList<>();
        if (!isEmpty(campaign.getDisabledPlaces())) {
            campaign.getDisabledPlaces().forEach(place -> knownSsp.forEach(ssp -> {
                if (place.equalsIgnoreCase(ssp)) {
                    disabledSsp.add(ssp);
                }
            }));
        }
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new McBannerCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.MCBANNER)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toNullableMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    public McBannerCampaign toCoreCampaign(GdAddMcBannerCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new McBannerCampaign()
                .withType(CampaignType.MCBANNER)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<McBannerCampaign> toModelChanges(McBannerCampaign campaign) {
        ModelChanges<McBannerCampaign> changes = new ModelChanges<>(campaign.getId(), McBannerCampaign.class)
                .process(campaign.getType(), McBannerCampaign.TYPE)
                .process(campaign.getName(), McBannerCampaign.NAME)
                .process(campaign.getStartDate(), McBannerCampaign.START_DATE)
                .process(campaign.getEndDate(), McBannerCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), McBannerCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledDomains(), McBannerCampaign.DISABLED_DOMAINS)
                .process(campaign.getDisabledSsp(), McBannerCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), McBannerCampaign.DISABLED_IPS)
                .process(campaign.getHasAddMetrikaTagToUrl(), McBannerCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasAddOpenstatTagToUrl(), McBannerCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getMinusKeywords(), McBannerCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), McBannerCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), McBannerCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), McBannerCampaign.EMAIL)
                .process(campaign.getWarningBalance(), McBannerCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(), McBannerCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), McBannerCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), McBannerCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getHasSiteMonitoring(), McBannerCampaign.HAS_SITE_MONITORING)
                .process(campaign.getHasExtendedGeoTargeting(), McBannerCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), McBannerCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), McBannerCampaign.USE_REGULAR_REGION)
                .process(campaign.getMeaningfulGoals(), McBannerCampaign.MEANINGFUL_GOALS)
                .process(campaign.getBidModifiers(), McBannerCampaign.BID_MODIFIERS)
                .process(campaign.getContextLimit(), McBannerCampaign.CONTEXT_LIMIT)
                .process(campaign.getEnableCpcHold(), McBannerCampaign.ENABLE_CPC_HOLD)
                .process(campaign.getAbSegmentRetargetingConditionId(),
                        McBannerCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        McBannerCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), McBannerCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), McBannerCampaign.AB_SEGMENT_GOAL_IDS)
                .process(campaign.getDayBudget(), McBannerCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), McBannerCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getStrategy(), McBannerCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), McBannerCampaign.TIME_TARGET)
                .process(campaign.getTimeZoneId(), McBannerCampaign.TIME_ZONE_ID)
                .process(campaign.getHref(), McBannerCampaign.HREF)
                .processNotNull(campaign.getBrandSafetyCategories(), McBannerCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        McBannerCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        McBannerCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsOrderPhraseLengthPrecedenceEnabled(),
                        McBannerCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                .processNotNull(campaign.getStrategyId(), McBannerCampaign.STRATEGY_ID);

        if (converterContext.getShouldProcessProperties().contains(McBannerCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentRetargetingConditionId(),
                    McBannerCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties()
                .contains(McBannerCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                    McBannerCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(McBannerCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), McBannerCampaign.CONTENT_LANGUAGE);
        }

        return changes;
    }
}
