package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddMobileContentCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateMobileContentCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter;
import ru.yandex.direct.model.ModelChanges;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.filterSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class MobileContentCampaignConverterSupport implements CampaignConverterSupport<MobileContentCampaign,
        GdUpdateMobileContentCampaign, GdAddMobileContentCampaign> {
    private final CampaignConverterContext converterContext;

    MobileContentCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public MobileContentCampaign toCoreCampaign(GdUpdateMobileContentCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = new ArrayList<>();
        if (!isEmpty(campaign.getDisabledPlaces())) {
            campaign.getDisabledPlaces().forEach(place -> knownSsp.forEach(ssp -> {
                if (place.equalsIgnoreCase(ssp)) {
                    disabledSsp.add(ssp);
                }
            }));
        }
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new MobileContentCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.MOBILE_CONTENT)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(filterSsp(knownSsp, campaign.getAllowedDomains()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDeviceTypeTargeting(CommonCampaignConverter
                        .toMobileAppDeviceTypeTargeting(campaign.getDeviceTypeTargeting()))
                .withNetworkTargeting(CommonCampaignConverter
                        .toMobileAppNetworkTargeting(campaign.getNetworkTargeting()))
                .withIsInstalledApp(campaign.getIsInstalledApp())
                .withMobileAppId(campaign.getMobileAppId())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withRequireFiltrationByDontShowDomains(false)
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsSkadNetworkEnabled(campaign.getIsSkadNetworkEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsNewIosVersionEnabled(campaign.getIsNewIosVersionEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    public MobileContentCampaign toCoreCampaign(GdAddMobileContentCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new MobileContentCampaign()
                .withType(CampaignType.MOBILE_CONTENT)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                        campaign.getAllowedDomains()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDeviceTypeTargeting(CommonCampaignConverter
                        .toMobileAppDeviceTypeTargeting(campaign.getDeviceTypeTargeting()))
                .withNetworkTargeting(CommonCampaignConverter
                        .toMobileAppNetworkTargeting(campaign.getNetworkTargeting()))
                .withIsInstalledApp(campaign.getIsInstalledApp())
                .withMobileAppId(campaign.getMobileAppId())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withRequireFiltrationByDontShowDomains(false)
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsSkadNetworkEnabled(campaign.getIsSkadNetworkEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsNewIosVersionEnabled(campaign.getIsNewIosVersionEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<MobileContentCampaign> toModelChanges(MobileContentCampaign campaign) {
        ModelChanges<MobileContentCampaign> changes = new ModelChanges<>(campaign.getId(), MobileContentCampaign.class)
                .process(campaign.getType(), MobileContentCampaign.TYPE)
                .process(campaign.getName(), MobileContentCampaign.NAME)
                .process(campaign.getStartDate(), MobileContentCampaign.START_DATE)
                .process(campaign.getEndDate(), MobileContentCampaign.END_DATE)
                .process(campaign.getDisabledSsp(), MobileContentCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), MobileContentCampaign.DISABLED_IPS)
                .process(campaign.getDisabledDomains(), MobileContentCampaign.DISABLED_DOMAINS)
                .process(campaign.getIsAloneTrafaretAllowed(), MobileContentCampaign.IS_ALONE_TRAFARET_ALLOWED)
                .process(campaign.getMinusKeywords(), MobileContentCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), MobileContentCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), MobileContentCampaign.SMS_FLAGS)
                .process(campaign.getHasTurboApp(), MobileContentCampaign.HAS_TURBO_APP)
                .process(campaign.getEmail(), MobileContentCampaign.EMAIL)
                .process(campaign.getWarningBalance(), MobileContentCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(),
                        MobileContentCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), MobileContentCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), MobileContentCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), MobileContentCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(), MobileContentCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getHasExtendedGeoTargeting(), MobileContentCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), MobileContentCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), MobileContentCampaign.USE_REGULAR_REGION)
                .process(campaign.getContextLimit(), MobileContentCampaign.CONTEXT_LIMIT)
                .process(campaign.getEnableCpcHold(), MobileContentCampaign.ENABLE_CPC_HOLD)
                .process(campaign.getDayBudget(), MobileContentCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), MobileContentCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getStrategy(), MobileContentCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), MobileContentCampaign.TIME_TARGET)
                .process(campaign.getTimeZoneId(), MobileContentCampaign.TIME_ZONE_ID)
                .processNotNull(campaign.getBrandSafetyCategories(), MobileContentCampaign.BRAND_SAFETY_CATEGORIES)
                .process(campaign.getBidModifiers(), MobileContentCampaign.BID_MODIFIERS)
                .process(campaign.getDeviceTypeTargeting(), MobileContentCampaign.DEVICE_TYPE_TARGETING)
                .process(campaign.getNetworkTargeting(), MobileContentCampaign.NETWORK_TARGETING)
                .process(campaign.getIsInstalledApp(), MobileContentCampaign.IS_INSTALLED_APP)
                .processNotNull(campaign.getMobileAppId(), MobileContentCampaign.MOBILE_APP_ID)
                .processNotNull(campaign.getIsOrderPhraseLengthPrecedenceEnabled(),
                        MobileContentCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                .process(campaign.getHref(), MobileContentCampaign.HREF)
                .process(false, MobileContentCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
                .processNotNull(campaign.getIsSkadNetworkEnabled(), MobileContentCampaign.IS_SKAD_NETWORK_ENABLED)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        MobileContentCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        MobileContentCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsNewIosVersionEnabled(), MobileContentCampaign.IS_NEW_IOS_VERSION_ENABLED)
                .processNotNull(campaign.getStrategyId(), MobileContentCampaign.STRATEGY_ID);

        if (converterContext.getShouldProcessProperties().contains(MobileContentCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), MobileContentCampaign.CONTENT_LANGUAGE);
        }
        if (converterContext.getShouldProcessProperties().contains(MobileContentCampaign.ALLOWED_PAGE_IDS)) {
            changes.process(campaign.getAllowedPageIds(), MobileContentCampaign.ALLOWED_PAGE_IDS);
            changes.process(campaign.getAllowedDomains(), TextCampaign.ALLOWED_DOMAINS);
            changes.process(campaign.getAllowedSsp(), TextCampaign.ALLOWED_SSP);
        }

        return changes;
    }
}
