package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddSmartCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateSmartCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.model.ModelChanges;

import static java.util.Collections.emptySet;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ADD_OPENSTAT_TAG_TO_URL;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_DAY_BUDGET;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_DAY_BUDGET_SHOW_MODE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_ENABLE_COMPANY_INFO;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_SITE_MONITORING;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_HAS_TITLE_SUBSTITUTION;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class SmartCampaignConverterSupport implements CampaignConverterSupport<SmartCampaign, GdUpdateSmartCampaign,
        GdAddSmartCampaign> {
    private final CampaignConverterContext converterContext;

    SmartCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public SmartCampaign toCoreCampaign(GdUpdateSmartCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = new ArrayList<>();
        if (!isEmpty(campaign.getDisabledPlaces())) {
            campaign.getDisabledPlaces().forEach(place -> knownSsp.forEach(ssp -> {
                if (place.equalsIgnoreCase(ssp)) {
                    disabledSsp.add(ssp);
                }
            }));
        }
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new SmartCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.PERFORMANCE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withHasTurboSmarts(campaign.getHasTurboSmarts())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasExtendedGeoTargeting(toHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting()))
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withContextLimit(campaign.getContextLimit())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withStrategyId(campaign.getStrategyId())
                // не используется, заполняем дефолтным значением
                .withEnableCompanyInfo(DEFAULT_ENABLE_COMPANY_INFO)
                // не используется, заполняем дефолтным значением
                .withEnableCpcHold(false)
                // не используется, заполняем дефолтным значением
                .withHasSiteMonitoring(DEFAULT_HAS_SITE_MONITORING)
                // не используется, заполняем дефолтным значением
                .withHasTitleSubstitution(DEFAULT_HAS_TITLE_SUBSTITUTION)
                // не используется, заполняем дефолтным значением
                .withDayBudget(DEFAULT_DAY_BUDGET)
                // не используется, заполняем дефолтным значением
                .withDayBudgetShowMode(DEFAULT_DAY_BUDGET_SHOW_MODE)
                // не используется, заполняем дефолтным значением
                .withHasAddOpenstatTagToUrl(DEFAULT_ADD_OPENSTAT_TAG_TO_URL)
                .withIsWwManagedOrder(campaign.getIsWwManagedOrder())
                // не используется, заполняем дефолтным значением
                .withPlacementTypes(emptySet());
    }

    @Override
    public SmartCampaign toCoreCampaign(GdAddSmartCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new SmartCampaign()
                .withType(CampaignType.PERFORMANCE)
                .withName(campaign.getName())
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withHasTurboSmarts(campaign.getHasTurboSmarts())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasExtendedGeoTargeting(toHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting()))
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withStrategy(toCampaignStrategy(campaign.getBiddingStrategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withStrategyId(campaign.getStrategyId())
                // не используется, заполняем дефолтным значением
                .withEnableCompanyInfo(DEFAULT_ENABLE_COMPANY_INFO)
                // не используется, заполняем дефолтным значением
                .withEnableCpcHold(false)
                // не используется, заполняем дефолтным значением
                .withHasSiteMonitoring(DEFAULT_HAS_SITE_MONITORING)
                // не используется, заполняем дефолтным значением
                .withHasTitleSubstitution(DEFAULT_HAS_TITLE_SUBSTITUTION)
                // не используется, заполняем дефолтным значением
                .withDayBudget(DEFAULT_DAY_BUDGET)
                // не используется, заполняем дефолтным значением
                .withDayBudgetShowMode(DEFAULT_DAY_BUDGET_SHOW_MODE)
                // не используется, заполняем дефолтным значением
                .withHasAddOpenstatTagToUrl(DEFAULT_ADD_OPENSTAT_TAG_TO_URL)
                // не используется, заполняем дефолтным значением
                .withPlacementTypes(emptySet())
                .withIsWwManagedOrder(campaign.getIsWwManagedOrder());
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<SmartCampaign> toModelChanges(SmartCampaign campaign) {
        ModelChanges<SmartCampaign> changes = new ModelChanges<>(campaign.getId(), SmartCampaign.class)
                .process(campaign.getType(), SmartCampaign.TYPE)
                .process(campaign.getName(), SmartCampaign.NAME)
                .process(campaign.getStartDate(), SmartCampaign.START_DATE)
                .process(campaign.getEndDate(), SmartCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), SmartCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledDomains(), SmartCampaign.DISABLED_DOMAINS)
                .process(campaign.getDisabledSsp(), SmartCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), SmartCampaign.DISABLED_IPS)
                .process(campaign.getIsAloneTrafaretAllowed(), SmartCampaign.IS_ALONE_TRAFARET_ALLOWED)
                .process(campaign.getHasTurboSmarts(), SmartCampaign.HAS_TURBO_SMARTS)
                .process(campaign.getHasTurboApp(), SmartCampaign.HAS_TURBO_APP)
                .process(campaign.getHasAddMetrikaTagToUrl(), SmartCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasExtendedGeoTargeting(), SmartCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), SmartCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), SmartCampaign.USE_REGULAR_REGION)
                .process(campaign.getMinusKeywords(), SmartCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), SmartCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), SmartCampaign.SMS_FLAGS)
                .process(campaign.getEmail(), SmartCampaign.EMAIL)
                .process(campaign.getWarningBalance(), SmartCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(), SmartCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), SmartCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), SmartCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), SmartCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(), SmartCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getMeaningfulGoals(), SmartCampaign.MEANINGFUL_GOALS)
                .process(campaign.getBidModifiers(), SmartCampaign.BID_MODIFIERS)
                .process(campaign.getContextLimit(), SmartCampaign.CONTEXT_LIMIT)
                .process(campaign.getAbSegmentRetargetingConditionId(),
                        SmartCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        SmartCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), SmartCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), SmartCampaign.AB_SEGMENT_GOAL_IDS)
                .process(campaign.getStrategy(), SmartCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), SmartCampaign.TIME_TARGET)
                .process(campaign.getAttributionModel(), SmartCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeZoneId(), SmartCampaign.TIME_ZONE_ID)
                .process(campaign.getHref(), SmartCampaign.HREF)
                .process(campaign.getBannerHrefParams(), SmartCampaign.BANNER_HREF_PARAMS)
                .process(campaign.getEnableCompanyInfo(), SmartCampaign.ENABLE_COMPANY_INFO)
                .process(campaign.getEnableCpcHold(), SmartCampaign.ENABLE_CPC_HOLD)
                .process(campaign.getHasSiteMonitoring(), SmartCampaign.HAS_SITE_MONITORING)
                .process(campaign.getHasTitleSubstitution(), SmartCampaign.HAS_TITLE_SUBSTITUTION)
                .process(campaign.getHasAddOpenstatTagToUrl(), SmartCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getDefaultPermalinkId(), SmartCampaign.DEFAULT_PERMALINK_ID)
                .process(campaign.getPlacementTypes(), SmartCampaign.PLACEMENT_TYPES)
                .process(campaign.getDayBudget(), SmartCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), SmartCampaign.DAY_BUDGET_SHOW_MODE)
                .processNotNull(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled(),
                        SmartCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                .processNotNull(
                        campaign.getIsSimplifiedStrategyViewEnabled(),
                        SmartCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED
                )
                .processNotNull(campaign.getBrandSafetyCategories(), SmartCampaign.BRAND_SAFETY_CATEGORIES)
                .processNotNull(campaign.getIsS2sTrackingEnabled(), SmartCampaign.IS_S2S_TRACKING_ENABLED)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        SmartCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        SmartCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsOrderPhraseLengthPrecedenceEnabled(),
                        SmartCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                .processNotNull(campaign.getIsWwManagedOrder(),
                        SmartCampaign.IS_WW_MANAGED_ORDER)
                .processNotNull(campaign.getStrategyId(), SmartCampaign.STRATEGY_ID);

        if (campaign.getRequireFiltrationByDontShowDomains() != null) {
            changes.process(campaign.getRequireFiltrationByDontShowDomains(),
                    SmartCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        }

        if (converterContext.getShouldProcessProperties().contains(SmartCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentRetargetingConditionId(),
                    SmartCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties()
                .contains(SmartCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                    SmartCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(SmartCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), SmartCampaign.CONTENT_LANGUAGE);
        }

        if (converterContext.getShouldProcessProperties().contains(SmartCampaign.ALLOWED_PAGE_IDS)) {
            changes.process(campaign.getAllowedPageIds(), SmartCampaign.ALLOWED_PAGE_IDS);
            changes.process(campaign.getAllowedDomains(), SmartCampaign.ALLOWED_DOMAINS);
            changes.process(campaign.getAllowedSsp(), SmartCampaign.ALLOWED_SSP);
        }

        return changes;
    }

    /**
     * Расширенный геоТаргетинг может быть не указан, в таком случае - значение по умолчанию true
     */
    private static Boolean toHasExtendedGeoTargeting(@Nullable Boolean hasExtendedGeoTargeting) {
        return hasExtendedGeoTargeting == null || hasExtendedGeoTargeting;
    }
}
