package ru.yandex.direct.grid.processing.service.campaign.converter.type;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.grid.model.campaign.GdCampAimType;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.campaign.facelift.GdAddUpdateCampaignAdditionalData;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdAddTextCampaign;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignEmailSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdCampaignSmsSettingsRequest;
import ru.yandex.direct.grid.processing.model.campaign.mutation.GdUpdateTextCampaign;
import ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignConverterContext;
import ru.yandex.direct.model.ModelChanges;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.CampaignUtils.getDisabledDomains;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toCampaignAttributionModel;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toContentLanguage;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.filterSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.getDisabledSsp;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.setScaleForCore;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBrandSafetyCategories;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toBroadMatch;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignDayBudgetShowMode;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignStrategy;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCampaignWarnPlaceInterval;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toCoreVcard;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMeaningfulGoals;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toNullableMetrikaCounters;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toPlacementTypes;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toSmsFlags;
import static ru.yandex.direct.grid.processing.service.campaign.converter.CommonCampaignConverter.toTimeInterval;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@SuppressWarnings("Duplicates")
@ParametersAreNonnullByDefault
public class TextCampaignConverterSupport implements CampaignConverterSupport<TextCampaign, GdUpdateTextCampaign,
        GdAddTextCampaign> {
    private final CampaignConverterContext converterContext;

    TextCampaignConverterSupport(CampaignConverterContext converterContext) {
        this.converterContext = converterContext;
    }

    @Override
    public TextCampaign toCoreCampaign(GdUpdateTextCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = new ArrayList<>();
        if (!isEmpty(campaign.getDisabledPlaces())) {
            campaign.getDisabledPlaces().forEach(place -> knownSsp.forEach(ssp -> {
                if (place.equalsIgnoreCase(ssp)) {
                    disabledSsp.add(ssp);
                }
            }));
        }
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new TextCampaign()
                .withId(campaign.getId())
                .withType(CampaignType.TEXT)
                .withName(campaign.getName())
                .withContactInfo(toCoreVcard(campaign.getVcard()))
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toNullableMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withPlacementTypes(toPlacementTypes(campaign.getPlacementTypes()))
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasTitleSubstitution(campaign.getHasTitleSubstitute())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withBroadMatch(toBroadMatch(campaign.getBroadMatch()))
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withClientDialogId(campaign.getClientDialogId())
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(filterSsp(knownSsp, campaign.getAllowedDomains()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withExcludePausedCompetingAds(campaign.getExcludePausedCompetingAds())
                .withEnableCompanyInfo(campaign.getEnableCompanyInfo())
                .withDefaultPermalinkId(campaign.getDefaultPermalinkId())
                .withDefaultChainId(campaign.getDefaultChainId())
                .withDefaultTrackingPhoneId(campaign.getDefaultTrackingPhoneId())
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withPromoExtensionId(campaign.getPromoExtensionId())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withCompanyName(ifNotNull(campaign.getAdditionalData(),
                        GdAddUpdateCampaignAdditionalData::getCompanyName))
                .withBusinessCategory(ifNotNull(campaign.getAdditionalData(),
                        GdAddUpdateCampaignAdditionalData::getBusinessCategory))
                .withCampAimType(ifNotNull(campaign.getCampAimType(), GdCampAimType::getTypedValue))
                .withCalltrackingSettingsId(campaign.getCalltrackingSettingsId())
                .withIsUniversal(campaign.getIsUniversalCamp())
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsAllowedOnAdultContent(campaign.getIsAllowedOnAdultContent())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    public TextCampaign toCoreCampaign(GdAddTextCampaign campaign) {
        GdCampaignSmsSettingsRequest smsSettings = campaign.getNotification().getSmsSettings();
        GdCampaignEmailSettingsRequest emailSettings = campaign.getNotification().getEmailSettings();

        //Проходим по всем переданным запрещенным местам, если есть в базе площадка(без проверки регистра), то
        //добавляем ее в запрещенные площадки в формате, в котором она записана в базе, иначе — в домены
        List<String> knownSsp = converterContext.getSspPlatforms();
        List<String> disabledSsp = getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                campaign.getDisabledPlaces());
        List<String> disabledDomains = getDisabledDomains(knownSsp, campaign.getDisabledPlaces());

        return new TextCampaign()
                .withType(CampaignType.TEXT)
                .withName(campaign.getName())
                .withContactInfo(toCoreVcard(campaign.getVcard()))
                .withStartDate(campaign.getStartDate())
                .withEndDate(campaign.getEndDate())
                .withMetrikaCounters(toMetrikaCounters(campaign.getMetrikaCounters()))
                .withDisabledDomains(disabledDomains)
                .withDisabledSsp(disabledSsp)
                .withDisabledIps(campaign.getDisabledIps())
                .withPlacementTypes(toPlacementTypes(campaign.getPlacementTypes()))
                .withRequireFiltrationByDontShowDomains(campaign.getRequireFiltrationByDontShowDomains())
                .withIsSimplifiedStrategyViewEnabled(campaign.getIsSimplifiedStrategyViewEnabled())
                .withIsMeaningfulGoalsValuesFromMetrikaEnabled(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled())
                .withHasExtendedGeoTargeting(campaign.getHasExtendedGeoTargeting())
                .withUseCurrentRegion(campaign.getUseCurrentRegion())
                .withUseRegularRegion(campaign.getUseRegularRegion())
                .withHasTitleSubstitution(campaign.getHasTitleSubstitute())
                .withIsAloneTrafaretAllowed(campaign.getIsAloneTrafaretAllowed())
                .withHasAddMetrikaTagToUrl(campaign.getHasAddMetrikaTagToUrl())
                .withHasAddOpenstatTagToUrl(campaign.getHasAddOpenstatTagToUrl())
                .withMinusKeywords(campaign.getMinusKeywords())
                .withSmsTime(toTimeInterval(smsSettings.getSmsTime()))
                .withSmsFlags(toSmsFlags(smsSettings.getEnableEvents()))
                .withHasTurboApp(campaign.getTurboAppsEnabled())
                .withEmail(emailSettings.getEmail())
                .withWarningBalance(emailSettings.getWarningBalance())
                .withEnableSendAccountNews(emailSettings.getSendAccountNews())
                .withEnablePausedByDayBudgetEvent(emailSettings.getStopByReachDailyBudget())
                .withEnableOfflineStatNotice(emailSettings.getXlsReady())
                .withEnableCheckPositionEvent(emailSettings.getCheckPositionInterval() != null)
                .withContentLanguage(toContentLanguage(campaign.getContentLanguage()))
                .withContextLimit(campaign.getContextLimit())
                .withEnableCpcHold(campaign.getEnableCpcHold())
                .withEnableCompanyInfo(campaign.getEnableCompanyInfo())
                .withExcludePausedCompetingAds(campaign.getExcludePausedCompetingAds())
                .withAttributionModel(toCampaignAttributionModel(campaign.getAttributionModel()))
                .withHasSiteMonitoring(campaign.getHasSiteMonitoring())
                .withMeaningfulGoals(toMeaningfulGoals(campaign.getMeaningfulGoals()))
                .withBroadMatch(toBroadMatch(campaign.getBroadMatch()))
                .withCheckPositionIntervalEvent(toCampaignWarnPlaceInterval(emailSettings.getCheckPositionInterval()))
                .withClientDialogId(campaign.getClientDialogId())
                .withAllowedPageIds(campaign.getAllowedPageIds())
                .withAllowedDomains(getDisabledDomains(knownSsp, campaign.getAllowedDomains()))
                .withAllowedSsp(getDisabledSsp(converterContext.getHostingsHandler(), knownSsp,
                        campaign.getAllowedDomains()))
                .withBidModifiers(BidModifierDataConverter.toBidModifiers(campaign.getBidModifiers()))
                .withDayBudget(setScaleForCore(campaign.getDayBudget()))
                .withDayBudgetShowMode(toCampaignDayBudgetShowMode(campaign.getDayBudgetShowMode()))
                .withDefaultPermalinkId(campaign.getDefaultPermalinkId())
                .withDefaultChainId(campaign.getDefaultChainId())
                .withDefaultTrackingPhoneId(campaign.getDefaultTrackingPhoneId())
                .withStrategy(toCampaignStrategy(campaign.getBiddingStategy()))
                .withTimeTarget(ifNotNull(campaign.getTimeTarget(), CampaignDataConverter::toTimeTarget))
                .withTimeZoneId(ifNotNull(campaign.getTimeTarget(), GdTimeTarget::getIdTimeZone))
                .withPromoExtensionId(campaign.getPromoExtensionId())
                .withAbSegmentStatisticRetargetingConditionId(campaign.getAbSegmentStatisticRetargetingConditionId())
                .withAbSegmentRetargetingConditionId(campaign.getAbSegmentRetargetingConditionId())
                .withSectionIds(campaign.getSectionIds())
                .withAbSegmentGoalIds(campaign.getAbSegmentGoalIds())
                .withBrandSafetyCategories(toBrandSafetyCategories(
                        campaign.getBrandSafetyCategories(), campaign.getBrandSafety()))
                .withHref(ifNotNull(campaign.getAdditionalData(), GdAddUpdateCampaignAdditionalData::getHref))
                .withBannerHrefParams(campaign.getBannerHrefParams())
                .withCompanyName(ifNotNull(campaign.getAdditionalData(),
                        GdAddUpdateCampaignAdditionalData::getCompanyName))
                .withBusinessCategory(ifNotNull(campaign.getAdditionalData(),
                        GdAddUpdateCampaignAdditionalData::getBusinessCategory))
                .withCampAimType(ifNotNull(campaign.getCampAimType(), GdCampAimType::getTypedValue))
                .withIsUniversal(campaign.getIsUniversalCamp())
                .withCalltrackingSettingsId(campaign.getCalltrackingSettingsId())
                .withIsTouch(false)
                .withIsOrderPhraseLengthPrecedenceEnabled(campaign.getIsOrderPhraseLengthPrecedenceEnabled())
                .withIsAllowedOnAdultContent(campaign.getIsAllowedOnAdultContent())
                .withIsRecommendationsManagementEnabled(campaign.getIsRecommendationsManagementEnabled())
                .withIsPriceRecommendationsManagementEnabled(campaign.getIsPriceRecommendationsManagementEnabled())
                .withIsS2sTrackingEnabled(campaign.getIsS2sTrackingEnabled())
                .withStrategyId(campaign.getStrategyId());
    }

    @Override
    @SuppressWarnings("java:S3252")
    public ModelChanges<TextCampaign> toModelChanges(TextCampaign campaign) {
        ModelChanges<TextCampaign> changes = new ModelChanges<>(campaign.getId(), TextCampaign.class)
                .process(campaign.getType(), TextCampaign.TYPE)
                .process(campaign.getName(), TextCampaign.NAME)
                .process(campaign.getContactInfo(), TextCampaign.CONTACT_INFO)
                .process(campaign.getStartDate(), TextCampaign.START_DATE)
                .process(campaign.getEndDate(), TextCampaign.END_DATE)
                .process(campaign.getMetrikaCounters(), TextCampaign.METRIKA_COUNTERS)
                .process(campaign.getDisabledDomains(), TextCampaign.DISABLED_DOMAINS)
                .process(campaign.getDisabledSsp(), TextCampaign.DISABLED_SSP)
                .process(campaign.getDisabledIps(), TextCampaign.DISABLED_IPS)
                .process(campaign.getPlacementTypes(), TextCampaign.PLACEMENT_TYPES)
                //пока идет эксперимент есть риск откатить фичу,
                //не хочется сбрасывать флаг без ведома пользователя в случае отката фичи,
                //поэтому processNotNull
                .processNotNull(campaign.getIsSimplifiedStrategyViewEnabled(),
                        TextCampaign.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                .processNotNull(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled(),
                        TextCampaign.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                .process(campaign.getHasTitleSubstitution(), TextCampaign.HAS_TITLE_SUBSTITUTION)
                .process(campaign.getIsAloneTrafaretAllowed(), TextCampaign.IS_ALONE_TRAFARET_ALLOWED)
                .process(campaign.getHasAddMetrikaTagToUrl(), TextCampaign.HAS_ADD_METRIKA_TAG_TO_URL)
                .process(campaign.getHasAddOpenstatTagToUrl(), TextCampaign.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .process(campaign.getMinusKeywords(), TextCampaign.MINUS_KEYWORDS)
                .process(campaign.getSmsTime(), TextCampaign.SMS_TIME)
                .process(campaign.getSmsFlags(), TextCampaign.SMS_FLAGS)
                .process(campaign.getHasTurboApp(), TextCampaign.HAS_TURBO_APP)
                .process(campaign.getEmail(), TextCampaign.EMAIL)
                .process(campaign.getWarningBalance(), TextCampaign.WARNING_BALANCE)
                .process(campaign.getEnablePausedByDayBudgetEvent(), TextCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT)
                .process(campaign.getEnableSendAccountNews(), TextCampaign.ENABLE_SEND_ACCOUNT_NEWS)
                .process(campaign.getEnableOfflineStatNotice(), TextCampaign.ENABLE_OFFLINE_STAT_NOTICE)
                .process(campaign.getEnableCheckPositionEvent(), TextCampaign.ENABLE_CHECK_POSITION_EVENT)
                .process(campaign.getCheckPositionIntervalEvent(), TextCampaign.CHECK_POSITION_INTERVAL_EVENT)
                .process(campaign.getHasSiteMonitoring(), TextCampaign.HAS_SITE_MONITORING)
                .process(campaign.getBroadMatch(), TextCampaign.BROAD_MATCH)
                .process(campaign.getHasExtendedGeoTargeting(), TextCampaign.HAS_EXTENDED_GEO_TARGETING)
                .processNotNull(campaign.getUseCurrentRegion(), TextCampaign.USE_CURRENT_REGION)
                .processNotNull(campaign.getUseRegularRegion(), TextCampaign.USE_REGULAR_REGION)
                .process(campaign.getClientDialogId(), TextCampaign.CLIENT_DIALOG_ID)
                .process(campaign.getMeaningfulGoals(), TextCampaign.MEANINGFUL_GOALS)
                .process(campaign.getBidModifiers(), TextCampaign.BID_MODIFIERS)
                .process(campaign.getContextLimit(), TextCampaign.CONTEXT_LIMIT)
                .process(campaign.getEnableCpcHold(), TextCampaign.ENABLE_CPC_HOLD)
                .process(campaign.getAbSegmentRetargetingConditionId(), TextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                        TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .process(campaign.getSectionIds(), TextCampaign.SECTION_IDS)
                .process(campaign.getAbSegmentGoalIds(), TextCampaign.AB_SEGMENT_GOAL_IDS)
                .process(campaign.getDayBudget(), TextCampaign.DAY_BUDGET)
                .process(campaign.getDayBudgetShowMode(), TextCampaign.DAY_BUDGET_SHOW_MODE)
                .process(campaign.getEnableCompanyInfo(), TextCampaign.ENABLE_COMPANY_INFO)
                .process(campaign.getExcludePausedCompetingAds(), TextCampaign.EXCLUDE_PAUSED_COMPETING_ADS)
                .process(campaign.getDefaultPermalinkId(), TextCampaign.DEFAULT_PERMALINK_ID)
                .process(campaign.getDefaultChainId(), TextCampaign.DEFAULT_CHAIN_ID)
                .process(campaign.getDefaultTrackingPhoneId(), TextCampaign.DEFAULT_TRACKING_PHONE_ID)
                .process(campaign.getStrategy(), TextCampaign.STRATEGY)
                .process(campaign.getTimeTarget(), TextCampaign.TIME_TARGET)
                .process(campaign.getAttributionModel(), TextCampaign.ATTRIBUTION_MODEL)
                .process(campaign.getTimeZoneId(), TextCampaign.TIME_ZONE_ID)
                .process(campaign.getPromoExtensionId(), TextCampaign.PROMO_EXTENSION_ID)
                .processNotNull(campaign.getBrandSafetyCategories(), TextCampaign.BRAND_SAFETY_CATEGORIES)
                .process(campaign.getHref(), TextCampaign.HREF)
                .process(campaign.getBannerHrefParams(), TextCampaign.BANNER_HREF_PARAMS)
                .process(campaign.getCompanyName(), TextCampaign.COMPANY_NAME)
                .process(campaign.getBusinessCategory(), TextCampaign.BUSINESS_CATEGORY)
                .processNotNull(campaign.getIsOrderPhraseLengthPrecedenceEnabled(),
                        TextCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED)
                //.process(campaign.getIsUniversal(), TextCampaign.IS_UNIVERSAL)  //DIRECT-130150
                .process(campaign.getCalltrackingSettingsId(), TextCampaign.CALLTRACKING_SETTINGS_ID)
                .process(campaign.getCampAimType(), TextCampaign.CAMP_AIM_TYPE)
                .processNotNull(campaign.getIsAllowedOnAdultContent(), TextCampaign.IS_ALLOWED_ON_ADULT_CONTENT)
                .processNotNull(campaign.getIsRecommendationsManagementEnabled(),
                        TextCampaign.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsPriceRecommendationsManagementEnabled(),
                        TextCampaign.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .processNotNull(campaign.getIsS2sTrackingEnabled(), TextCampaign.IS_S2S_TRACKING_ENABLED)
                .processNotNull(campaign.getStrategyId(), TextCampaign.STRATEGY_ID);

        if (campaign.getRequireFiltrationByDontShowDomains() != null) {
            changes.process(campaign.getRequireFiltrationByDontShowDomains(), TextCampaign.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        }


        if (converterContext.getShouldProcessProperties().contains(TextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentRetargetingConditionId(),
                    TextCampaign.AB_SEGMENT_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties()
                .contains(TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)) {
            changes.process(campaign.getAbSegmentStatisticRetargetingConditionId(),
                    TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID);
        }
        if (converterContext.getShouldProcessProperties().contains(TextCampaign.CONTENT_LANGUAGE)) {
            changes.process(campaign.getContentLanguage(), TextCampaign.CONTENT_LANGUAGE);
        }
        if (converterContext.getShouldProcessProperties().contains(TextCampaign.ALLOWED_PAGE_IDS)) {
            changes.process(campaign.getAllowedPageIds(), TextCampaign.ALLOWED_PAGE_IDS);
            changes.process(campaign.getAllowedDomains(), TextCampaign.ALLOWED_DOMAINS);
            changes.process(campaign.getAllowedSsp(), TextCampaign.ALLOWED_SSP);
        }

        return changes;
    }
}
