package ru.yandex.direct.grid.processing.service.campaign.loader;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;
import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.model.campaign.GdCampaignAgencyInfo;
import ru.yandex.direct.grid.processing.service.campaign.CampaignAgencyManagerInfoHelper;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
@ParametersAreNonnullByDefault
public class CampaignAgencyInfoByAgencyUidDataLoader extends GridBatchingDataLoader<Long, GdCampaignAgencyInfo> {
    public CampaignAgencyInfoByAgencyUidDataLoader(
            GridContextProvider gridContextProvider,
            CampaignAgencyManagerInfoHelper campaignAgencyManagerInfoHelper
    ) {
        var batchLoadFunction = getBatchLoadFunction(campaignAgencyManagerInfoHelper);
        this.dataLoader = mappedDataLoader(gridContextProvider, batchLoadFunction);
    }

    private MappedBatchLoaderWithContext<Long, GdCampaignAgencyInfo> getBatchLoadFunction(
            CampaignAgencyManagerInfoHelper campaignAgencyManagerInfoHelper) {
        return (agencyUserIds, environment) -> {
            if (CollectionUtils.isEmpty(agencyUserIds)) {
                return CompletableFuture.completedFuture(Map.of());
            }
            return CompletableFuture.completedFuture(
                    campaignAgencyManagerInfoHelper.getCampaignAgencyInfoByUid(new HashSet<>(agencyUserIds)));
        };
    }
}
