package ru.yandex.direct.grid.processing.service.campaign.loader;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.core.entity.turbolanding.service.TurboLandingService;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
@ParametersAreNonnullByDefault
public class CampaignHrefIsTurboDataLoader extends GridBatchingDataLoader<String, Boolean> {

    public CampaignHrefIsTurboDataLoader(GridContextProvider gridContextProvider,
                                         TurboLandingService turboLandingService) {
        this.dataLoader = mappedDataLoader(gridContextProvider, getBatchLoadFunction(turboLandingService));
    }

    private MappedBatchLoaderWithContext<String, Boolean> getBatchLoadFunction(
            TurboLandingService turboLandingService
    ) {
        return (hrefs, environment) -> {
            Map<String, TurboLanding> turbolandingByUrlMap = turboLandingService.findTurboLandingsByUrl(hrefs);

            var isTurboByHref =
                    listToMap(hrefs, identity(), href -> turbolandingByUrlMap.get(href) != null);

            return CompletableFuture.completedFuture(isTurboByHref);
        };
    }
}
