package ru.yandex.direct.grid.processing.service.campaign.loader;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.pricepackage.GdPricePackageForClient;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;
import ru.yandex.direct.grid.processing.service.pricepackage.PricePackageDataService;

@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
@ParametersAreNonnullByDefault
public class CampaignsPricePackageDataLoader extends GridBatchingDataLoader<Long, GdPricePackageForClient> {

    @Autowired
    public CampaignsPricePackageDataLoader(GridContextProvider gridContextProvider,
                                           PricePackageDataService pricePackageDataService) {
        this.dataLoader = mappedDataLoader(gridContextProvider, getBatchLoadFunction(pricePackageDataService));
    }

    private MappedBatchLoaderWithContext<Long, GdPricePackageForClient> getBatchLoadFunction(
            PricePackageDataService pricePackageDataService) {
        return (pricePackageIds, environment) -> {
            GridGraphQLContext context = environment.getContext();
            var result = pricePackageDataService.getPricePackagesForClient(pricePackageIds,
                    context.getOperator().getUid());
            return CompletableFuture.completedFuture(result);
        };
    }
}
