package ru.yandex.direct.grid.processing.service.campaign.loader;

import java.util.Objects;

public class GetBrandSurveyStatusKey {
    private final Long cid;
    private final String brandSurveyId;

    public GetBrandSurveyStatusKey(Long cid, String brandSurveyId) {
        this.cid = cid;
        this.brandSurveyId = brandSurveyId;
    }

    public Long getCid() {
        return cid;
    }

    public String getBrandSurveyId() {
        return brandSurveyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBrandSurveyStatusKey that = (GetBrandSurveyStatusKey) o;
        return Objects.equals(cid, that.cid) && Objects.equals(brandSurveyId, that.brandSurveyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cid, brandSurveyId);
    }
}
