package ru.yandex.direct.grid.processing.service.campaign.uc

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects
import ru.yandex.direct.grid.processing.model.promoextension.GdUpdateCampaignsPromoExtension
import ru.yandex.direct.grid.processing.service.campaign.CampaignAccessHelper.MANAGE_PROMOACTION_CAMPAIGN_TYPES
import ru.yandex.direct.grid.processing.service.campaign.CampaignValidationService
import ru.yandex.direct.grid.processing.service.validation.GridValidationService
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CollectionConstraints
import ru.yandex.direct.validation.constraint.CommonConstraints.validId
import ru.yandex.direct.validation.util.listProperty
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject

fun validateUpdateCampaignsWithPromoExtension(
        gridValidationService: GridValidationService,
        updateCampaignsWithPromoExtension: GdUpdateCampaignsPromoExtension?,
        cidToTypeMap: Map<Long, CampaignType>
) {
    gridValidationService.applyValidator(
        { req: GdUpdateCampaignsPromoExtension ->
            validateObject(req) {
                listProperty(GdUpdateCampaignsPromoExtension::campaignIds) {
                    check(CollectionConstraints.notEmptyCollection())
                    check(CollectionConstraints.maxListSize(CampaignValidationService.MAX_CAMPAIGNS_COUNT_PER_UPDATE))
                    checkEach(validId())
                    checkEach(Constraint.fromPredicate(
                        { cid -> cidToTypeMap.contains(cid) },CampaignDefects.campaignNotFound()), When.isValid())
                    checkEach(Constraint.fromPredicate(
                        { cid -> MANAGE_PROMOACTION_CAMPAIGN_TYPES.contains(cidToTypeMap[cid]) },
                        CampaignDefects.campaignTypeNotSupported()), When.isValid())
                }
                property(GdUpdateCampaignsPromoExtension::promoExtensionId) {
                    check(validId(), When.notNull())
                }
            }
        },
        updateCampaignsWithPromoExtension, false
    )
}

