package ru.yandex.direct.grid.processing.service.campaign.uc;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonObjectType;
import ru.yandex.direct.grid.processing.model.constants.GdLanguage;

public class UcModerationReasonRequestItem {
    private final Long objectId;
    @Nullable
    private final Long subObjectId; //нужно для id фразы при id группы
    private final ModerationReasonObjectType objectType;
    private final GdLanguage gdLanguage;

    public UcModerationReasonRequestItem(Long objectId, Long subObjectId,
                                         ModerationReasonObjectType objectType, GdLanguage gdLanguage) {
        this.objectId = objectId;
        this.subObjectId = subObjectId;
        this.objectType = objectType;
        this.gdLanguage = gdLanguage;
    }

    public Long getObjectId() {
        return objectId;
    }

    public Long getSubObjectId() {
        return subObjectId;
    }

    public ModerationReasonObjectType getObjectType() {
        return objectType;
    }

    public GdLanguage getGdLanguage() {
        return gdLanguage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UcModerationReasonRequestItem that = (UcModerationReasonRequestItem) o;
        return objectId.equals(that.objectId) &&
                Objects.equals(subObjectId, that.subObjectId) &&
                objectType == that.objectType &&
                gdLanguage == that.gdLanguage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(objectId, subObjectId, objectType, gdLanguage);
    }
}
