package ru.yandex.direct.grid.processing.service.campaign.uc;

import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;

public final class ValidationResultPathByIndexTransformer implements ValidationResult.ValidationResultTransformer<Defect> {
    private final Map<Integer, Integer> currentIndexToSourceIndex;

    public ValidationResultPathByIndexTransformer(Map<Integer, Integer> currentIndexToSourceIndex) {
        this.currentIndexToSourceIndex = currentIndexToSourceIndex;
    }

    public Map<PathNode, ValidationResult<?, Defect>> transformSubResults(
            Path path,
            Map<PathNode, ValidationResult<?, Defect>> subResults
    ) {
        return subResults
                .entrySet()
                .stream()
                .collect(Collectors.toMap(e -> getNewPathNode(e.getKey()), Map.Entry::getValue));
    }

    private PathNode getNewPathNode(PathNode pathNode) {
        if (pathNode instanceof PathNode.Index) {
            final var currentIndex = ((PathNode.Index) pathNode).getIndex();

            return new PathNode.Index(currentIndexToSourceIndex.getOrDefault(currentIndex, currentIndex));
        }

        return pathNode;
    }
}
