package ru.yandex.direct.grid.processing.service.client;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.sharding.ShardKey;
import ru.yandex.direct.dbutil.sharding.ShardSupport;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClientDevInfo;
import ru.yandex.direct.rbac.RbacService;

@Service
@ParametersAreNonnullByDefault
public class ClientDevDataService {

    private final ShardSupport shardSupport;
    private final RbacService rbacService;
    private final FeatureService featureService;
    private final EnvironmentType environmentType;

    @Autowired
    public ClientDevDataService(ShardSupport shardSupport, RbacService rbacService,
                                FeatureService featureService, EnvironmentType environmentType) {
        this.shardSupport = shardSupport;
        this.rbacService = rbacService;
        this.featureService = featureService;
        this.environmentType = environmentType;
    }

    public GdClientDevInfo getClientDevInfo(GridGraphQLContext context) {
        User subjectUser = context.getSubjectUser();
        long clientId = subjectUser.getClientId().asLong();
        int shard = shardSupport.getShard(ShardKey.CLIENT_ID, clientId);
        Long uid = subjectUser.getUid();

        return new GdClientDevInfo()
                .withClientId(clientId)
                .withShard(shard)
                .withUid(uid)
                .withEnvironment(environmentType.name())
                .withRole(rbacService.getUidRole(uid))
                .withOperatorLogin(context.getOperator().getLogin());
    }

    Set<String> getUserFeatures(User user) {
        return featureService.getEnabledForClientId(user.getClientId());
    }
}
